/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.user;

import csbase.client.util.user.UsersPermissionsTable;
import csbase.logic.User;
import csbase.logic.UserOutline;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public class UserPanel
extends JPanel {
    private JTextField filterText;
    private JButton filterButton;
    protected UsersPermissionsTable sharedUsersTable;
    protected Set<Object> usersRO = new HashSet<Object>();
    protected Set<Object> usersRW = new HashSet<Object>();
    protected final boolean showPermissions;
    protected Set<Object> selectedUsers;
    private final JCheckBox usersOnlyBox = new JCheckBox();
    private final JCheckBox nonUsersOnlyBox = new JCheckBox();
    protected final boolean fixedAccess;

    public UserPanel(List<UserOutline> allUsers, boolean showPermissions) {
        this.showPermissions = showPermissions;
        this.fixedAccess = true;
        this.filterUsers(allUsers);
        this.sharedUsersTable = new UsersPermissionsTable(allUsers, this.usersRO, this.usersRW);
        this.initPanel();
    }

    public UserPanel(List<UserOutline> allUsers, Set<Object> usersRO, Set<Object> usersRW, boolean showPermissions) {
        this.showPermissions = showPermissions;
        this.fixedAccess = false;
        this.filterUsers(allUsers);
        this.sharedUsersTable = new UsersPermissionsTable(allUsers, usersRO, usersRW);
        this.initComponents();
        this.initPanel();
    }

    public UserPanel(List<UserOutline> allUsers, Set<Object> usersRO, Set<Object> usersRW, boolean showPermissions, boolean fixedAccess) {
        this.showPermissions = showPermissions;
        this.fixedAccess = fixedAccess;
        this.filterUsers(allUsers);
        this.sharedUsersTable = new UsersPermissionsTable(allUsers, usersRO, usersRW);
        this.initComponents();
        this.initPanel();
    }

    private void initComponents() {
        this.usersOnlyBox.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.nonUsersOnlyBox.setSelected(false);
                UserPanel.this.filterTableContentByAccess();
            }
        });
        this.usersOnlyBox.setText(LNG.get((String)"UserPanel.users.only.checkbox.title"));
        this.nonUsersOnlyBox.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.usersOnlyBox.setSelected(false);
                UserPanel.this.filterTableContentByAccess();
            }
        });
        this.nonUsersOnlyBox.setText(LNG.get((String)"UserPanel.non.users.only.checkbox.title"));
    }

    private void initPanel() {
        ListSelectionModel listSelectionModel = this.sharedUsersTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selectedRows = UserPanel.this.sharedUsersTable.getSelectedRows();
                UserPanel.this.selectedUsers = new HashSet<Object>();
                for (int row : selectedRows) {
                    Object id = UserPanel.this.sharedUsersTable.getValueAt(row, 0);
                    UserPanel.this.selectedUsers.add(id);
                }
            }
        });
        this.createGUI();
    }

    public Set<Object> getSelectedUsers() {
        return this.selectedUsers;
    }

    private void filterUsers(List<UserOutline> allUsers) {
        for (UserOutline userOutline : allUsers) {
            Object id = userOutline.getId();
            if (!id.equals(User.getAdminId())) continue;
            allUsers.remove(userOutline);
            break;
        }
    }

    private void createGUI() {
        if (!this.showPermissions) {
            TableColumnModel columnModel = this.sharedUsersTable.getColumnModel();
            TableColumn column4 = columnModel.getColumn(3);
            TableColumn column3 = columnModel.getColumn(2);
            columnModel.removeColumn(column4);
            columnModel.removeColumn(column3);
        }
        this.setLayout(new GridBagLayout());
        this.addInputPanels(0);
    }

    private int addInputPanels(int ypos) {
        int y = ypos;
        GBC gbc = new GBC(0, y++).both();
        this.add((Component)this.createSharedUsersPanel(), gbc);
        return y;
    }

    protected JPanel createSharedUsersPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel leftFilterPanel = new JPanel(new GridBagLayout());
        JPanel rightFilterPanel = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.sharedUsersTable));
        GBC gbc = new GBC(0, 0).both().width(3);
        panel.add((Component)scrollPane, gbc);
        gbc = new GBC(0, 0).west().insets(10, 0, 10, 0);
        JLabel filterLabel = new JLabel(LNG.get((String)"UserPanel.filter.label"));
        leftFilterPanel.add((Component)filterLabel, gbc);
        this.filterText = new JTextField();
        gbc = new GBC(1, 0).insets(10).horizontal().filly();
        leftFilterPanel.add((Component)this.filterText, gbc);
        this.filterButton = new JButton(LNG.get((String)"UserPanel.filter.clear"));
        gbc = new GBC(2, 0).east().insets(10, 0, 10, 10);
        leftFilterPanel.add((Component)this.filterButton, gbc);
        gbc = new GBC(0, 0).west().top(10);
        rightFilterPanel.add((Component)this.nonUsersOnlyBox, gbc);
        gbc = new GBC(0, 1).west().top(2);
        rightFilterPanel.add((Component)this.usersOnlyBox, gbc);
        gbc = new GBC(0, 1).horizontal().northwest().width(2).top(5);
        panel.add((Component)leftFilterPanel, gbc);
        if (!this.fixedAccess) {
            gbc = new GBC(2, 1).northwest().width(1).insets(5, 15, 0, 0);
            panel.add((Component)rightFilterPanel, gbc);
        }
        this.setupFilterControls();
        return panel;
    }

    private void setupFilterControls() {
        Document document = this.filterText.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                UserPanel.this.filterTableContentByAccess();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UserPanel.this.filterTableContentByAccess();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UserPanel.this.filterTableContentByAccess();
            }
        });
        this.filterText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                UserPanel.this.filterText.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                UserPanel.this.filterText.select(0, 0);
            }
        });
        this.filterButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPanel.this.filterText.setText("");
                UserPanel.this.filterTableContentByAccess();
            }
        });
    }

    private void filterTableContent() {
        String text = this.filterText.getText();
        if (text.length() > 0) {
            this.sharedUsersTable.setRowFilter(RowFilter.regexFilter("(?i).*" + text + ".*", 0, 1));
        } else {
            this.sharedUsersTable.setRowFilter(null);
        }
    }

    private void filterTableContentByAccess() {
        ArrayList filters;
        RowFilter rf1;
        boolean usersOnly = this.usersOnlyBox.isSelected();
        boolean nonUsersOnly = this.nonUsersOnlyBox.isSelected();
        if (!usersOnly && !nonUsersOnly) {
            this.filterTableContent();
            return;
        }
        if (usersOnly) {
            rf1 = RowFilter.regexFilter("true", 2, 3);
        } else {
            RowFilter filter1 = RowFilter.regexFilter("false", 2);
            RowFilter filter2 = RowFilter.regexFilter("false", 3);
            filters = new ArrayList(2);
            filters.add(filter1);
            filters.add(filter2);
            rf1 = RowFilter.andFilter(filters);
        }
        String text = this.filterText.getText();
        if (text.length() > 0) {
            RowFilter rf2 = RowFilter.regexFilter("(?i).*" + text + ".*", 0, 1);
            filters = new ArrayList(2);
            filters.add(rf1);
            filters.add(rf2);
            RowFilter filter = RowFilter.andFilter(filters);
            this.sharedUsersTable.setRowFilter(filter);
        } else {
            this.sharedUsersTable.setRowFilter(rf1);
        }
    }

    public void enableSharedUsersPanel(boolean enabled) {
        this.sharedUsersTable.setEnabled(enabled);
        this.filterText.setEnabled(enabled);
        this.filterButton.setEnabled(enabled);
        this.usersOnlyBox.setEnabled(enabled);
        this.nonUsersOnlyBox.setEnabled(enabled);
    }

    public void setTableSelection(boolean multipleSelection) {
        ListSelectionModel selectionModel = this.sharedUsersTable.getSelectionModel();
        if (multipleSelection) {
            selectionModel.setSelectionMode(2);
        } else {
            selectionModel.setSelectionMode(0);
        }
    }

    public void fillUserSets() {
        this.sharedUsersTable.fillUserSets(this.usersRO, this.usersRW);
    }

    public Set<Object> getUsersRO() {
        return this.usersRO;
    }

    public Set<Object> getUsersRW() {
        return this.usersRW;
    }

    public boolean hasUsersPermissionsChanged() {
        return this.sharedUsersTable.hasUsersPermissionsChanged();
    }
}

