/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.AbstractSimpleApplicationPanel;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.dialogs.CommonEditTabbedPanel;
import csbase.client.util.ClientUtilities;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;

public abstract class CommonInfoEditPanel
extends AbstractSimpleApplicationPanel<AlgorithmsManager> {
    public static final String STR_UPDATE = "*";
    private CommonEditTabbedPanel dataPane;
    private JButton applyButton;
    private JButton cancelButton;

    public CommonInfoEditPanel(CommonEditTabbedPanel dataPane) {
        super(dataPane.getApplication());
        this.dataPane = dataPane;
        this.buildPanel();
    }

    public CommonEditTabbedPanel getEditPanel() {
        return this.dataPane;
    }

    protected abstract JPanel buildMainInfoPanel();

    protected abstract void apply();

    protected abstract void cancel();

    protected abstract String getTitle();

    public abstract void initializeData();

    public abstract void setDataChanged();

    public abstract boolean wasModified();

    @Override
    protected void buildPanel() {
        this.setLayout(new GridBagLayout());
        JPanel mainPanel = this.buildMainInfoPanel();
        JPanel buttonsPanel = this.getButtonPanel();
        this.add((Component)mainPanel, new GBC(0, 0).both().insets(5, 5, 5, 5));
        this.add((Component)buttonsPanel, new GBC(0, 2).none().insets(5, 5, 5, 10));
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.applyButton = new JButton(((AlgorithmsManager)this.getApplication()).getString("CommonInfoEditPanel.button.apply"));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(e -> this.apply());
        this.cancelButton = new JButton(((AlgorithmsManager)this.getApplication()).getString("CommonInfoEditPanel.button.cancel"));
        this.cancelButton.setEnabled(false);
        this.cancelButton.addActionListener(e -> this.cancel());
        buttonPanel.add((Component)this.applyButton, new GBC(0, 0).none().south().insets(5, 5, 5, 5));
        buttonPanel.add((Component)this.cancelButton, new GBC(1, 0).south().insets(5, 5, 5, 5));
        ClientUtilities.adjustEqualSizes(this.applyButton, this.cancelButton);
        return buttonPanel;
    }

    protected void showOperationButtons(boolean toshow) {
        this.applyButton.setVisible(toshow);
        this.cancelButton.setVisible(toshow);
    }

    protected void setApplyActionState(boolean changed) {
        this.applyButton.setEnabled(changed);
        String title = !changed ? this.getTitle() : this.getTitle() + STR_UPDATE;
        this.dataPane.setInfoPanelTitle(this, title);
    }

    protected void setCancelActionState(boolean state) {
        this.cancelButton.setEnabled(state);
    }

    protected void changeOperationsState(boolean changed) {
        this.setApplyActionState(changed);
        this.setCancelActionState(changed);
    }

    protected JPanel buildEmptyPanel() {
        return new JPanel();
    }
}

