/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.zoom;

import csbase.client.applications.flowapplication.zoom.ZoomListener;
import csbase.client.applications.flowapplication.zoom.ZoomModel;
import javax.swing.DefaultBoundedRangeModel;

public final class ZoomSliderModel
extends DefaultBoundedRangeModel {
    private final ZoomModel zoomModel;

    public ZoomSliderModel(ZoomModel model) {
        super(ZoomSliderModel.toSliderValue(model.getValue()), 0, ZoomSliderModel.toSliderValue(model.getMinValue()), ZoomSliderModel.toSliderValue(model.getMaxValue()));
        this.zoomModel = model;
        this.zoomModel.addListener(new ZoomSliderModelListener());
    }

    public int getMajorTicks() {
        return 5 * this.getMinorTicks();
    }

    public int getMinorTicks() {
        return ZoomSliderModel.toSliderValue(this.zoomModel.getBlockIncrement());
    }

    @Override
    public int getValue() {
        return ZoomSliderModel.toSliderValue(this.zoomModel.getValue());
    }

    @Override
    public void setValue(int sliderValue) {
        this.zoomModel.setValue(ZoomSliderModel.fromSliderValue(sliderValue));
    }

    private static double fromSliderValue(int sliderValue) {
        return (double)sliderValue / 100.0;
    }

    private static int toSliderValue(double zoomValue) {
        return (int)Math.round(zoomValue * 100.0);
    }

    private class ZoomSliderModelListener
    implements ZoomListener {
        private ZoomSliderModelListener() {
        }

        @Override
        public void wasChanged(ZoomModel model) {
            ZoomSliderModel.this.fireStateChanged();
        }
    }
}

