/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.cache;

import csbase.client.algorithms.commands.cache.CommandsFilter;
import csbase.client.algorithms.commands.cache.events.AbstractCacheUpdatedEventListener;
import csbase.client.algorithms.commands.cache.events.AbstractCommandUpdatedEventListener;
import csbase.client.algorithms.commands.cache.events.CacheUpdatedEvent;
import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent;
import csbase.client.algorithms.commands.cache.events.FinishedOrSystemFailureCommandsLoadingEvent;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.client.util.CodeBlockLog;
import csbase.client.util.event.EventListener;
import csbase.client.util.event.EventManager;
import csbase.client.util.event.IEvent;
import csbase.logic.CommandInfo;
import csbase.logic.CommandNotification;
import csbase.logic.CommandStatus;
import csbase.logic.CommonClientProject;
import csbase.logic.Priority;
import csbase.logic.algorithms.commands.CommandPersistenceNotification;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.CommandPersistenceServiceInterface;
import csbase.remote.SchedulerServiceInterface;
import csbase.util.TaskScheduler;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.javautils.core.lng.LNG;

public final class CommandsCache {
    private static Logger LOGGER = Logger.getLogger(CommandsCache.class.getName());
    private static final long DEFAULT_RELOAD_INTERVAL_S = 30L;
    private static final long LOAD_FINISHEDS_DESIRED_RESPONSE_TIME_MILLIS = 3000L;
    private static CommandsCache instance = new CommandsCache();
    private final ReentrantReadWriteLock commandsLock = new ReentrantReadWriteLock();
    private final Map<String, CommandInfo> commandsById = new HashMap<String, CommandInfo>();
    private HashSet<CommandInfo> scheduledCommands = new HashSet();
    private HashSet<CommandInfo> finishedOrSystemFailureCommands = new HashSet();
    private Lock finishedOrSystemFailureCommandsLock = new ReentrantLock();
    private AtomicInteger finishedOrSystemFailureCommandListenersCounter = new AtomicInteger(0);
    private Object projectId;
    private final Lock eventManagerLock = new ReentrantLock();
    private final EventManager eventManager = new EventManager();
    private final long reloadInterval = this.getReloadInterval();
    private final TimeUnit reloadIntervalUnit = TimeUnit.SECONDS;
    private long lastUpdateInMilliseconds = 0L;
    private AtomicBoolean exceptionThrownDuringLastUpdate = new AtomicBoolean(false);
    private TaskScheduler reloader;

    private CommandsCache() {
        CommonClientProject project = DesktopFrame.getInstance().getProject();
        if (null != project) {
            this.projectId = project.getId();
        }
        this.reloader = this.createReloader();
        this.initializeListeners();
    }

    public static CommandsCache getInstance() {
        return instance;
    }

    public boolean hasCommand(String commandId) throws RemoteException {
        return this.getCommandFromCache(commandId) != null;
    }

    public Collection<CommandInfo> getCommands() throws RemoteException {
        this.runManualReload(true);
        return this.getSnapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<CommandInfo> getCommands(CommandsFilter filter) throws RemoteException {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINE, "obtendo comandos nos estados %s", Arrays.toString(filter.getAllowedStatus().toArray(new CommandStatus[0])));
        LOGGER.log(methodLog.begin());
        boolean loadFinishedCommands = filter.getAllowedStatus().contains(CommandStatus.FINISHED);
        this.runManualReload(loadFinishedCommands);
        CodeBlockLog filterLog = new CodeBlockLog(Level.FINER, "filtragem de comando", new Object[0]);
        LOGGER.log(filterLog.begin());
        this.commandsLock.readLock().lock();
        try {
            ArrayList<CommandInfo> filtereds = new ArrayList<CommandInfo>();
            for (CommandInfo command : this.commandsById.values()) {
                if (!filter.accept(command)) continue;
                filtereds.add(command);
            }
            LOGGER.log(filterLog.finished());
            ArrayList<CommandInfo> arrayList = filtereds;
            return arrayList;
        }
        finally {
            this.commandsLock.readLock().unlock();
            LOGGER.log(methodLog.finished());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CommandInfo getCommand(CommandsFilter filter) throws RemoteException {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINE, "obtendo 1 comando em um dos estados %s", Arrays.toString(filter.getAllowedStatus().toArray(new CommandStatus[0])));
        LOGGER.log(methodLog.begin());
        boolean loadFinishedOrSystemFailureCommands = filter.getAllowedStatus().contains(CommandStatus.FINISHED) || filter.getAllowedStatus().contains(CommandStatus.SYSTEM_FAILURE);
        this.runManualReload(loadFinishedOrSystemFailureCommands);
        CodeBlockLog filterLog = new CodeBlockLog(Level.FINER, "filtragem de comando", new Object[0]);
        LOGGER.log(filterLog.begin());
        this.commandsLock.readLock().lock();
        try {
            for (CommandInfo command : this.commandsById.values()) {
                if (!filter.accept(command)) continue;
                CommandInfo commandInfo = command;
                return commandInfo;
            }
            Iterator<CommandInfo> iterator = null;
            return iterator;
        }
        finally {
            this.commandsLock.readLock().unlock();
            LOGGER.log(filterLog.finished());
            LOGGER.log(methodLog.finished());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CommandInfo getCommand(Object prjId, String cmdId) throws RemoteException {
        CommandInfo command;
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINE, "obtendo comando " + cmdId + " do projeto " + prjId, new Object[0]);
        LOGGER.log(methodLog.begin());
        this.commandsLock.readLock().lock();
        try {
            command = this.getCommandFromCache(cmdId);
            if (null == command) {
                CodeBlockLog searchServerLog = new CodeBlockLog(Level.FINER, "busca do comando " + cmdId + " do projeto " + prjId + " no servidor", new Object[0]);
                LOGGER.log(searchServerLog.begin());
                command = ClientRemoteLocator.commandPersistenceService.getCommandInfo(prjId, cmdId);
                LOGGER.log(searchServerLog.finished());
                if (null != command) {
                    this.saveInCache(command);
                    CodeBlockLog fireEventsLog = new CodeBlockLog(Level.FINER, "disparo de eventos", new Object[0]);
                    LOGGER.log(fireEventsLog.begin());
                    CommandUpdatedEvent.Type type = CommandUpdatedEvent.Type.valueOf(command.getFinalizationType());
                    this.eventManager.fireEvent(new CommandUpdatedEvent(command, type));
                    this.eventManager.fireEvent(new CacheUpdatedEvent(this.getSnapshot()));
                    LOGGER.log(fireEventsLog.finished());
                }
            }
        }
        finally {
            this.commandsLock.readLock().unlock();
        }
        LOGGER.log(methodLog.finished());
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] removeCommands(List<CommandInfo> commands) throws RemoteException {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINE, "remo\u00e7\u00e3o de comandos", new Object[0]);
        LOGGER.log(methodLog.begin());
        boolean updateCache = false;
        boolean[] result = new boolean[commands.size()];
        Arrays.fill(result, false);
        ArrayList<String> removeAlloweds = new ArrayList<String>();
        ArrayList<Object> projectIds = new ArrayList<Object>();
        ArrayList<Integer> allowedsInx2commandsInx = new ArrayList<Integer>();
        for (int cmdInx = 0; cmdInx < commands.size(); ++cmdInx) {
            CommandInfo command = commands.get(cmdInx);
            if (command.getStatus() != CommandStatus.FINISHED && command.getStatus() != CommandStatus.SYSTEM_FAILURE) continue;
            removeAlloweds.add(command.getId());
            projectIds.add(command.getProjectId());
            allowedsInx2commandsInx.add(cmdInx);
        }
        boolean[] allowedsResult = ClientRemoteLocator.commandPersistenceService.removeCommandInfos(projectIds, removeAlloweds);
        for (int inx = 0; inx < removeAlloweds.size(); ++inx) {
            int cmdInx = (Integer)allowedsInx2commandsInx.get(inx);
            if (-1 >= cmdInx) continue;
            result[cmdInx] = allowedsResult[inx];
            updateCache |= allowedsResult[inx];
        }
        if (updateCache) {
            Collection<CommandInfo> cacheSnapshot;
            int inx;
            boolean cacheUpdated = false;
            this.commandsLock.writeLock().lock();
            try {
                for (inx = 0; inx < commands.size(); ++inx) {
                    if (!result[inx]) continue;
                    cacheUpdated |= null != this.removeFromCache(commands.get(inx).getId());
                }
                cacheSnapshot = this.getSnapshot();
            }
            finally {
                this.commandsLock.writeLock().unlock();
            }
            for (inx = 0; inx < commands.size(); ++inx) {
                if (!result[inx]) continue;
                this.eventManager.fireEvent(new CommandUpdatedEvent(commands.get(inx), CommandUpdatedEvent.Type.removed));
            }
            if (cacheUpdated) {
                this.eventManager.fireEvent(new CacheUpdatedEvent(cacheSnapshot));
            }
        }
        LOGGER.log(methodLog.finished());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePriority(CommandInfo command) throws RemoteException {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINE, "atualiza\u00e7\u00e3o de prioridade do comando " + command.getId(), new Object[0]);
        LOGGER.log(methodLog.begin());
        try {
            Priority priority;
            String cmdId;
            SchedulerServiceInterface schedulerService;
            boolean set;
            CommandStatus status = command.getStatus();
            if (status == CommandStatus.SCHEDULED && (set = (schedulerService = ClientRemoteLocator.schedulerService).setPriority((Object)(cmdId = command.getId()), priority = command.getPriority()))) {
                this.eventManager.fireEvent(new CommandUpdatedEvent(command, CommandUpdatedEvent.Type.updated));
                Collection<CommandInfo> snapshot = this.getSnapshot();
                this.eventManager.fireEvent(new CacheUpdatedEvent(snapshot));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            LOGGER.log(methodLog.finished());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePosition(CommandInfo command) throws RemoteException {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINE, "atualiza\u00e7\u00e3o de posi\u00e7\u00e3o do comando " + command.getId(), new Object[0]);
        LOGGER.log(methodLog.begin());
        try {
            int position;
            String cmdId;
            boolean set;
            if (command.getStatus() == CommandStatus.SCHEDULED && (set = ClientRemoteLocator.schedulerService.setPosition((Object)(cmdId = command.getId()), position = command.getGlobalPosition()))) {
                this.reload();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            LOGGER.log(methodLog.finished());
        }
    }

    public void updateDescription(CommandInfo command) throws RemoteException {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINE, "atualiza\u00e7\u00e3o de descri\u00e7\u00e3o do comando " + command.getId(), new Object[0]);
        LOGGER.log(methodLog.begin());
        try {
            switch (command.getStatus()) {
                case SCHEDULED: {
                    ClientRemoteLocator.schedulerService.updateCommandDescription(command.getId(), command.getDescription());
                    break;
                }
                case FINISHED: {
                    ClientRemoteLocator.commandPersistenceService.updateCommandDescription(command.getProjectId(), command.getId(), command.getDescription());
                    break;
                }
                case SYSTEM_FAILURE: {
                    break;
                }
                default: {
                    ClientRemoteLocator.sgaService.updateCommandDescription(command.getId(), command.getDescription());
                }
            }
            this.eventManager.fireEvent(new CommandUpdatedEvent(command, CommandUpdatedEvent.Type.updated));
            this.eventManager.fireEvent(new CacheUpdatedEvent(this.getSnapshot()));
        }
        finally {
            LOGGER.log(methodLog.finished());
        }
    }

    public void addEventListener(AbstractCacheUpdatedEventListener listener) {
        this.addEventListener(listener, CacheUpdatedEvent.class);
        CommandsFilter filter = listener.getFilter();
        Collection<CommandStatus> allowedStatus = filter.getAllowedStatus();
        if (allowedStatus.contains(CommandStatus.FINISHED) || allowedStatus.contains(CommandStatus.SYSTEM_FAILURE)) {
            this.finishedOrSystemFailureCommandListenersCounter.incrementAndGet();
        }
    }

    public void addEventListener(AbstractCommandUpdatedEventListener listener) {
        this.addEventListener(listener, CommandUpdatedEvent.class);
    }

    public void addEventListener(EventListener<FinishedOrSystemFailureCommandsLoadingEvent> listener) {
        this.addEventListener(listener, FinishedOrSystemFailureCommandsLoadingEvent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IEvent, L extends EventListener<E>> void removeEventListener(L listener) {
        this.eventManagerLock.lock();
        try {
            AbstractCacheUpdatedEventListener cnvListener;
            CommandsFilter filter;
            Collection<CommandStatus> allowedStatus;
            this.eventManager.removeEventListener(listener);
            if (listener instanceof AbstractCacheUpdatedEventListener && ((allowedStatus = (filter = (cnvListener = (AbstractCacheUpdatedEventListener)listener).getFilter()).getAllowedStatus()).contains(CommandStatus.FINISHED) || allowedStatus.contains(CommandStatus.SYSTEM_FAILURE))) {
                this.finishedOrSystemFailureCommandListenersCounter.decrementAndGet();
            }
            if (0 == this.eventManager.countListeners()) {
                this.reloader.stop();
            }
        }
        finally {
            this.eventManagerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveInCache(CommandInfo cmd) {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINER, "persistindo comando " + cmd.getId() + " no estado " + cmd.getStatus() + " na cache", new Object[0]);
        LOGGER.log(methodLog.begin());
        this.commandsLock.writeLock().lock();
        try {
            this.scheduledCommands.remove(cmd);
            CommandStatus status = cmd.getStatus();
            String cmdId = cmd.getId();
            switch (status) {
                case SYSTEM_FAILURE: {
                    CommandInfo cachedCmd = this.commandsById.get(cmdId);
                    if (cachedCmd == null) {
                        this.finishedOrSystemFailureCommands.add(cmd);
                        break;
                    }
                    if (cachedCmd.getStatus() != CommandStatus.FINISHED) break;
                    if (null == this.projectId || !this.projectId.equals(cmd.getProjectId())) {
                        this.commandsById.remove(cmdId);
                        boolean bl = false;
                        return bl;
                    }
                    this.finishedOrSystemFailureCommands.add(cmd);
                    break;
                }
                case FINISHED: {
                    if (null == this.projectId || !this.projectId.equals(cmd.getProjectId())) {
                        this.commandsById.remove(cmdId);
                        boolean bl = false;
                        return bl;
                    }
                    this.finishedOrSystemFailureCommands.add(cmd);
                    break;
                }
                case SCHEDULED: {
                    this.scheduledCommands.add(cmd);
                    break;
                }
            }
            this.commandsById.put(cmdId, cmd);
        }
        finally {
            this.commandsLock.writeLock().unlock();
            LOGGER.log(methodLog.finished());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandInfo removeFromCache(String commandId) {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINER, "removendo comando " + commandId + " da cache", new Object[0]);
        LOGGER.log(methodLog.begin());
        this.commandsLock.writeLock().lock();
        try {
            CommandInfo cmd = this.commandsById.remove(commandId);
            if (cmd == null) {
                CommandInfo commandInfo = null;
                return commandInfo;
            }
            CommandStatus status = cmd.getStatus();
            switch (status) {
                case SCHEDULED: {
                    this.scheduledCommands.remove(cmd);
                    break;
                }
                case FINISHED: 
                case SYSTEM_FAILURE: {
                    this.finishedOrSystemFailureCommands.remove(cmd);
                    break;
                }
            }
            CommandInfo commandInfo = cmd;
            return commandInfo;
        }
        finally {
            this.commandsLock.writeLock().unlock();
            LOGGER.log(methodLog.finished());
        }
    }

    private void initializeListeners() {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINE, "inicializa\u00e7\u00e3o de ouvintes", new Object[0]);
        LOGGER.log(methodLog.begin());
        CodeBlockLog messageLog = new CodeBlockLog(Level.FINER, "criando IMessageListener para fim de comandos", new Object[0]);
        LOGGER.log(messageLog.begin());
        MessageProxy.addListener(new IMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessagesReceived(Message ... messages) throws Exception {
                long missing = Integer.MAX_VALUE;
                long total = 0L;
                CommandsCache.this.commandsLock.writeLock().lock();
                try {
                    for (Message aMessage : messages) {
                        CommandPersistenceServiceInterface.CommandInfosRetrived data = (CommandPersistenceServiceInterface.CommandInfosRetrived)aMessage.getBody();
                        for (CommandInfo aCommand : data.getCommandInfos()) {
                            LOGGER.log(Level.FINEST, "IMessageListener: CmdId:" + aCommand.getId() + ", Status:" + aCommand.getStatus());
                            if (aCommand.getStatus() != CommandStatus.FINISHED && aCommand.getStatus() != CommandStatus.SYSTEM_FAILURE) continue;
                            CommandsCache.this.saveInCache(aCommand);
                        }
                        total = data.getTotal();
                        missing = Math.min(missing, data.getMissing());
                    }
                }
                finally {
                    CommandsCache.this.commandsLock.writeLock().unlock();
                }
                missing = Math.min(missing, total);
                CommandsCache.this.eventManager.fireEvent(new FinishedOrSystemFailureCommandsLoadingEvent(missing, total));
                CommandsCache.this.eventManager.fireEvent(new CacheUpdatedEvent(CommandsCache.this.getSnapshot()));
            }
        }, CommandPersistenceServiceInterface.CommandInfosRetrived.class);
        LOGGER.log(messageLog.finished());
        CodeBlockLog schedulerLog = new CodeBlockLog(Level.FINER, "criando SchedulerObserver", new Object[0]);
        LOGGER.log(schedulerLog.begin());
        LOGGER.log(schedulerLog.finished());
        CodeBlockLog projectTreeLog = new CodeBlockLog(Level.FINER, "criando ProjectTreeListener", new Object[0]);
        LOGGER.log(projectTreeLog.begin());
        DesktopFrame.getInstance().getTree().addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject project) {
                if (null == project && null == CommandsCache.this.projectId || null != project && project.getId().equals(CommandsCache.this.projectId)) {
                    return;
                }
                CommandsCache.this.projectId = null == project ? null : project.getId();
                if (CommandsCache.this.finishedOrSystemFailureCommandListenersCounter.get() == 0) {
                    CommandsCache.this.cleanFinishedCommands();
                    return;
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CommandsCache.this.loadFinishedOrSystemFailureCommands();
                            CommandsCache.this.eventManager.fireEvent(new CacheUpdatedEvent(CommandsCache.this.getSnapshot()));
                        }
                        catch (Exception e) {
                            CommandsCache.this.throwExceptionAsEvent(e);
                        }
                    }
                };
                ThreadFactory threadFactory = Executors.defaultThreadFactory();
                Thread thread = threadFactory.newThread(runnable);
                thread.start();
            }

            @Override
            public void projectClosed(CommonClientProject project) {
                CommandsCache.this.cleanFinishedCommands();
                CommandsCache.this.projectId = null;
                if (0 < CommandsCache.this.finishedOrSystemFailureCommandListenersCounter.get()) {
                    Collection snapshot = CommandsCache.this.getSnapshot();
                    CommandsCache.this.eventManager.fireEvent(new CacheUpdatedEvent(snapshot));
                }
            }
        });
        LOGGER.log(projectTreeLog.finished());
        CodeBlockLog cmdLog = new CodeBlockLog(Level.FINER, "criando CommandListener", new Object[0]);
        LOGGER.log(cmdLog.begin());
        MessageProxy.addListener(new IMessageListener(){

            public void onMessagesReceived(final Message ... messages) throws Exception {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (Message message : messages) {
                                CommandNotification notification = (CommandNotification)message.getBody();
                                Object prjId = notification.getProjectId();
                                String cmdId = notification.getCommandId().toString();
                                LOGGER.log(Level.FINEST, "CommandListener: CmdId:" + cmdId + ", project:" + prjId);
                                CodeBlockLog log = new CodeBlockLog(Level.FINEST, "obtendo dados do comando " + cmdId + " do servi\u00e7o de persist\u00eancia", new Object[0]);
                                LOGGER.log(log.begin());
                                CommandInfo command = ClientRemoteLocator.commandPersistenceService.getCommandInfo(prjId, cmdId);
                                LOGGER.log(log.finished());
                                if (command == null) {
                                    return;
                                }
                                CommandUpdatedEvent.Type type = CommandUpdatedEvent.Type.valueOf(command.getFinalizationType());
                                CommandsCache.this.eventManager.fireEvent(new CommandUpdatedEvent(command, type));
                                CommandsCache.this.saveInCache(command);
                                CommandsCache.this.eventManager.fireEvent(new CacheUpdatedEvent(CommandsCache.this.getSnapshot()));
                            }
                        }
                        catch (Exception e) {
                            CommandsCache.this.throwExceptionAsEvent(e);
                        }
                    }
                };
                ThreadFactory threadFactory = Executors.defaultThreadFactory();
                Thread thread = threadFactory.newThread(runnable);
                thread.start();
            }
        }, CommandNotification.class);
        LOGGER.log(cmdLog.finished());
        CodeBlockLog cmdPersistLog = new CodeBlockLog(Level.FINER, "criando CommandPersistenceListener", new Object[0]);
        LOGGER.log(cmdPersistLog.begin());
        MessageProxy.addListener(new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    final CommandPersistenceNotification notification = (CommandPersistenceNotification)message.getBody();
                    Runnable processNotification = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object prjId = notification.getProjectId();
                            String cmdId = notification.getCommandId();
                            Collection cacheSnapshot = null;
                            CommandInfo command = null;
                            switch (notification.getType()) {
                                case REMOVED: {
                                    LOGGER.log(Level.FINEST, "CommandPersistenceListener: REMOVED CmdId:" + cmdId, "project:" + prjId);
                                    CommandsCache.this.commandsLock.writeLock().lock();
                                    try {
                                        command = CommandsCache.this.removeFromCache(cmdId);
                                        if (command != null) {
                                            cacheSnapshot = CommandsCache.this.getSnapshot();
                                        }
                                    }
                                    finally {
                                        CommandsCache.this.commandsLock.writeLock().unlock();
                                    }
                                    if (command == null) break;
                                    CommandsCache.this.eventManager.fireEvent(new CommandUpdatedEvent(command, CommandUpdatedEvent.Type.removed));
                                    CommandsCache.this.eventManager.fireEvent(new CacheUpdatedEvent(cacheSnapshot));
                                    break;
                                }
                                case SAVED: {
                                    LOGGER.log(Level.FINEST, "CommandPersistenceListener: SAVED CmdId:" + cmdId, "project:" + prjId);
                                    CommandsCache.this.commandsLock.writeLock().lock();
                                    try {
                                        if (CommandsCache.this.commandsById.containsKey(cmdId)) {
                                            return;
                                        }
                                        CodeBlockLog log = new CodeBlockLog(Level.FINEST, "obtendo dados do comando " + cmdId + " do servi\u00e7o de persist\u00eancia", new Object[0]);
                                        LOGGER.log(log.begin());
                                        command = ClientRemoteLocator.commandPersistenceService.getCommandInfo(prjId, cmdId);
                                        LOGGER.log(log.finished());
                                        if (command != null) {
                                            CommandsCache.this.saveInCache(command);
                                            cacheSnapshot = CommandsCache.this.getSnapshot();
                                        }
                                    }
                                    catch (Exception e) {
                                        CommandsCache.this.throwExceptionAsEvent(e);
                                    }
                                    finally {
                                        CommandsCache.this.commandsLock.writeLock().unlock();
                                    }
                                    if (command == null) break;
                                    CommandsCache.this.eventManager.fireEvent(new CommandUpdatedEvent(command, CommandUpdatedEvent.Type.created));
                                    CommandsCache.this.eventManager.fireEvent(new CacheUpdatedEvent(cacheSnapshot));
                                    break;
                                }
                                case UPDATED: {
                                    LOGGER.log(Level.FINEST, "CommandPersistenceListener: UPDATED CmdId:" + cmdId, "project:" + prjId);
                                    CommandsCache.this.commandsLock.writeLock().lock();
                                    try {
                                        CodeBlockLog log = new CodeBlockLog(Level.FINEST, "obtendo dados do comando " + cmdId + " do servi\u00e7o de persist\u00eancia", new Object[0]);
                                        LOGGER.log(log.begin());
                                        command = ClientRemoteLocator.commandPersistenceService.getCommandInfo(prjId, cmdId);
                                        LOGGER.log(log.finished());
                                        if (command != null) {
                                            CommandsCache.this.saveInCache(command);
                                            cacheSnapshot = CommandsCache.this.getSnapshot();
                                        }
                                    }
                                    catch (Exception e) {
                                        CommandsCache.this.throwExceptionAsEvent(e);
                                    }
                                    finally {
                                        CommandsCache.this.commandsLock.writeLock().unlock();
                                    }
                                    if (command == null) break;
                                    CommandsCache.this.eventManager.fireEvent(new CommandUpdatedEvent(command, CommandUpdatedEvent.Type.updated));
                                    CommandsCache.this.eventManager.fireEvent(new CacheUpdatedEvent(cacheSnapshot));
                                    break;
                                }
                                default: {
                                    String errorMessage = String.format("Notifica\u00e7\u00e3o de tipo desconhecido.\nProjeto: %s.\nComando: %s.\nTipo de notifica\u00e7\u00e3o: %s.\n", CommandsCache.this.projectId, cmdId, notification.getType());
                                    throw new IllegalArgumentException(errorMessage);
                                }
                            }
                        }
                    };
                    ThreadFactory threadFactory = Executors.defaultThreadFactory();
                    Thread thread = threadFactory.newThread(processNotification);
                    thread.start();
                }
            }
        }, CommandPersistenceNotification.class);
        LOGGER.log(cmdPersistLog.finished());
        LOGGER.log(methodLog.finished());
    }

    private void cleanScheduledCommands() {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINER, "limpando comandos agendados", new Object[0]);
        LOGGER.log(methodLog.begin());
        for (CommandInfo scheduledCommand : this.scheduledCommands) {
            this.commandsById.remove(scheduledCommand.getId());
        }
        this.scheduledCommands.clear();
        LOGGER.log(methodLog.finished());
    }

    private void loadScheduledCommands(Set<CommandUpdatedEvent> accumulator) throws RemoteException {
        this.scheduledCommands.clear();
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINER, "carregando comandos agendados", new Object[0]);
        LOGGER.log(methodLog.begin());
        CommandInfo[] queueds = ClientRemoteLocator.schedulerService.getQueuedCommands();
        LOGGER.log(methodLog.finished());
        CodeBlockLog eventLog = new CodeBlockLog(Level.FINER, "notificacao de comandos agendados", new Object[0]);
        LOGGER.log(eventLog.begin());
        for (CommandInfo aScheduledCommand : queueds) {
            if (null != accumulator) {
                boolean updated = this.commandsById.containsKey(aScheduledCommand.getId());
                CommandUpdatedEvent.Type eventType = updated ? CommandUpdatedEvent.Type.updated : CommandUpdatedEvent.Type.created;
                accumulator.add(new CommandUpdatedEvent(aScheduledCommand, eventType));
            }
            this.saveInCache(aScheduledCommand);
        }
        LOGGER.log(eventLog.finished());
    }

    private void loadRunningCommands(Set<CommandUpdatedEvent> accumulator) throws RemoteException {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINER, "carregando comandos em execu\u00e7\u00e3o", new Object[0]);
        LOGGER.log(methodLog.begin());
        Vector runningCommands = ClientRemoteLocator.sgaService.getAllSGACommands();
        LOGGER.log(methodLog.finished());
        CodeBlockLog eventLog = new CodeBlockLog(Level.FINER, "notificacao de comandos em execu\u00e7\u00e3o", new Object[0]);
        LOGGER.log(eventLog.begin());
        for (CommandInfo runningCommand : runningCommands) {
            this.saveInCache(runningCommand);
            if (null == accumulator) continue;
            accumulator.add(new CommandUpdatedEvent(runningCommand, CommandUpdatedEvent.Type.updated));
        }
        LOGGER.log(eventLog.finished());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanFinishedCommands() {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINER, "limpando comandos terminados", new Object[0]);
        LOGGER.log(methodLog.begin());
        this.finishedOrSystemFailureCommandsLock.lock();
        try {
            if (this.finishedOrSystemFailureCommands.size() == 0) {
                return;
            }
            this.commandsLock.writeLock().lock();
            try {
                for (CommandInfo scheduledCommand : this.finishedOrSystemFailureCommands) {
                    this.commandsById.remove(scheduledCommand.getId());
                }
                this.finishedOrSystemFailureCommands.clear();
            }
            finally {
                this.commandsLock.writeLock().unlock();
            }
        }
        finally {
            this.finishedOrSystemFailureCommandsLock.unlock();
            LOGGER.log(methodLog.finished());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFinishedOrSystemFailureCommands() throws RemoteException {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINER, "carregando comandos terminados", new Object[0]);
        LOGGER.log(methodLog.begin());
        this.finishedOrSystemFailureCommandsLock.lock();
        try {
            if (null == this.projectId) {
                return;
            }
            long loading = ClientRemoteLocator.commandPersistenceService.requestCommandInfos(this.projectId, 3000L);
            this.eventManager.fireEvent(new FinishedOrSystemFailureCommandsLoadingEvent(loading));
        }
        finally {
            this.finishedOrSystemFailureCommandsLock.unlock();
        }
        LOGGER.log(methodLog.finished());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hardReload(Object prjId) throws RemoteException {
        this.commandsLock.writeLock().lock();
        try {
            Iterator<CommandInfo> iterator = this.commandsById.values().iterator();
            while (iterator.hasNext()) {
                CommandInfo command = iterator.next();
                if (!command.getProjectId().equals(prjId)) continue;
                iterator.remove();
            }
        }
        finally {
            this.commandsLock.writeLock().unlock();
        }
        this.runManualReload(0 < this.finishedOrSystemFailureCommandListenersCounter.get() && prjId.equals(this.projectId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() throws RemoteException {
        Collection<CommandInfo> commands;
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINEST, "recarga de comandos", new Object[0]);
        LOGGER.log(methodLog.begin());
        HashSet<CommandUpdatedEvent> events = new HashSet<CommandUpdatedEvent>();
        this.commandsLock.readLock().lock();
        try {
            if (this.exceptionThrownDuringLastUpdate.compareAndSet(true, false)) {
                for (CommandInfo command : this.commandsById.values()) {
                    CommandUpdatedEvent event = new CommandUpdatedEvent(command, CommandUpdatedEvent.Type.updated);
                    events.add(event);
                }
            }
        }
        finally {
            this.commandsLock.readLock().unlock();
        }
        this.commandsLock.writeLock().lock();
        try {
            this.cleanScheduledCommands();
            this.loadScheduledCommands(events);
            this.loadRunningCommands(events);
            this.lastUpdateInMilliseconds = System.currentTimeMillis();
            commands = this.getSnapshot();
        }
        finally {
            this.commandsLock.writeLock().unlock();
        }
        LOGGER.log(methodLog.finished());
        CodeBlockLog eventLog = new CodeBlockLog(Level.FINEST, "notifica\u00e7\u00e3o de comandos", new Object[0]);
        LOGGER.log(eventLog.begin());
        for (CommandUpdatedEvent event : events) {
            this.eventManager.fireEvent(event);
        }
        this.eventManager.fireEvent(new CacheUpdatedEvent(commands));
        LOGGER.log(eventLog.finished());
    }

    private boolean runManualReload(boolean loadFinishedCommands) throws RemoteException {
        boolean status = false;
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINE, "recarga manual de comandos", new Object[0]);
        LOGGER.log(methodLog.begin());
        if (!this.reloader.isRunning()) {
            long expirationDate = this.lastUpdateInMilliseconds + this.reloadIntervalUnit.toMillis(this.reloadInterval);
            if (System.currentTimeMillis() > expirationDate) {
                this.reload();
                status = true;
            }
        }
        if (loadFinishedCommands) {
            this.loadFinishedOrSystemFailureCommands();
        }
        LOGGER.log(methodLog.begin());
        return status;
    }

    private TaskScheduler createReloader() {
        Runnable reloadTask = new Runnable(){

            @Override
            public void run() {
                try {
                    CommandsCache.this.reload();
                }
                catch (Exception e) {
                    CommandsCache.this.throwExceptionAsEvent(e);
                }
            }
        };
        return new TaskScheduler(reloadTask, this.reloadInterval, this.reloadIntervalUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getReloadInterval() {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINE, "obtendo intervalo de recarga de comandos", new Object[0]);
        LOGGER.log(methodLog.begin());
        try {
            RemoteTask<Long> task = new RemoteTask<Long>(){

                protected void performTask() throws Exception {
                    long interval = ClientRemoteLocator.sgaService.getCommandsUpdateInterval();
                    this.setResult(interval);
                }
            };
            DesktopComponentFrame window = DesktopFrame.getInstance().getDesktopFrame();
            String title = DesktopFrame.getInstance().getTitle();
            String message = LNG.get((String)"CommandsCache.task.message");
            if (task.execute(window, title, message)) {
                long l = (Long)task.getResult();
                return l;
            }
            long l = 30L;
            return l;
        }
        finally {
            LOGGER.log(methodLog.finished());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandInfo getCommandFromCache(String commandId) throws RemoteException {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINE, "pegando comando " + commandId + " da cache", new Object[0]);
        LOGGER.log(methodLog.begin());
        this.runManualReload(false);
        this.commandsLock.readLock().lock();
        try {
            CommandInfo commandInfo = this.commandsById.get(commandId);
            return commandInfo;
        }
        finally {
            this.commandsLock.readLock().unlock();
            LOGGER.log(methodLog.finished());
        }
    }

    private Collection<CommandInfo> getSnapshot() {
        CodeBlockLog methodLog = new CodeBlockLog(Level.FINEST, "obtendo snapshot", new Object[0]);
        LOGGER.log(methodLog.begin());
        ArrayList<CommandInfo> values = new ArrayList<CommandInfo>();
        this.commandsLock.readLock().lock();
        try {
            values.addAll(this.commandsById.values());
        }
        finally {
            this.commandsLock.readLock().unlock();
            LOGGER.log(methodLog.finished());
        }
        return values;
    }

    private void throwExceptionAsEvent(Exception e) {
        String updateCacheExceptionMsg;
        String updateCmdExceptionMsg;
        if (e instanceof RemoteException) {
            ClientRemoteMonitor.getInstance().invalidate();
            updateCacheExceptionMsg = updateCmdExceptionMsg = LNG.get((String)"CommandsCache.exception.RemoteException");
        } else {
            updateCacheExceptionMsg = LNG.get((String)"CommandsCache.exception.cache.update");
            updateCmdExceptionMsg = LNG.get((String)"CommandsCache.exception.command.update");
        }
        this.eventManager.fireEvent(new CommandUpdatedEvent(e, updateCmdExceptionMsg));
        this.eventManager.fireEvent(new CacheUpdatedEvent(e, updateCacheExceptionMsg));
        this.exceptionThrownDuringLastUpdate.set(true);
    }

    private <E extends IEvent, L extends EventListener<E>> void addEventListener(L listener, Class<E> clazz) {
        this.eventManagerLock.lock();
        try {
            this.eventManager.addEventListener(listener, clazz);
            this.reloader.start();
        }
        finally {
            this.eventManagerLock.unlock();
        }
    }
}

