/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.NumberTextFieldModel;
import csbase.client.algorithms.parameters.NumberTextFieldModelListener;
import csbase.exception.ParseException;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class NumberTextField<N extends Number>
extends JTextField {
    private Border defaultBorder = this.getBorder();
    private Border errorBorder = BorderFactory.createLineBorder(Color.RED, 2);
    private NumberTextFieldModel<N> model;

    protected NumberTextField(NumberTextFieldModel<N> model) {
        this.setModel(model);
        this.updateView();
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NumberTextField.this.validateText();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NumberTextField.this.validateText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NumberTextField.this.validateText();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                NumberTextField.this.updateModel();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    public final void updateView() {
        N modelValue = this.model.getValue();
        if (modelValue == null) {
            this.setText("");
        } else if (!modelValue.equals(this.model.getErrorValue())) {
            this.setText(this.format(modelValue));
        }
    }

    protected abstract String format(N var1);

    protected abstract N parse(String var1) throws ParseException;

    private void setModel(NumberTextFieldModel<N> model) {
        if (model == null) {
            throw new IllegalArgumentException("O par\u00e2metro model est\u00e1 nulo.");
        }
        this.model = model;
        this.model.addNumberTextFieldModelListener(new NumberTextFieldModelListener(){

            @Override
            public void wasChangedValue() {
                NumberTextField.this.updateView();
            }
        });
    }

    private void updateModel() {
        String text = this.getText();
        if (text.length() == 0) {
            this.model.setValue(null);
        } else {
            try {
                N number = this.parse(text);
                this.model.setValue(number);
            }
            catch (ParseException exception) {
                N err = this.model.getErrorValue();
                this.model.setValue(err);
            }
        }
    }

    private void validateText() {
        String text = this.getText();
        if (text.length() == 0) {
            this.setBorder(this.defaultBorder);
        } else {
            try {
                this.parse(text);
                this.setBorder(this.defaultBorder);
            }
            catch (ParseException exception) {
                this.setBorder(this.errorBorder);
            }
        }
    }
}

