/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.logic.applicationservice.ApplicationCategory;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class ApplicationManagerMenuUtilities {
    public static final JPopupMenu buildPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        List<JMenu> menuList = ApplicationManagerMenuUtilities.mountCategoriesMenuList();
        for (JMenu mn : menuList) {
            menu.add(mn);
        }
        return menu;
    }

    public static final JMenu buildMenu(String title) {
        JMenu menu = new JMenu();
        menu.setText(title);
        List<JMenu> menuList = ApplicationManagerMenuUtilities.mountCategoriesMenuList();
        for (JMenu mn : menuList) {
            menu.add(mn);
        }
        return menu;
    }

    private static List<JMenu> mountCategoriesMenuList() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        ApplicationManager mgr = ApplicationManager.getInstance();
        if (mgr == null) {
            return menuList;
        }
        Hashtable<String, ApplicationCategory> cts = mgr.getAllApplicationCategories();
        Collection<ApplicationCategory> categories = cts.values();
        for (ApplicationCategory cat : categories) {
            if (!cat.isShownAtApplicationMenu()) continue;
            JMenu mn = ApplicationManagerMenuUtilities.buildCategoryMenu(cat);
            menuList.add(mn);
        }
        Collections.sort(menuList, new Comparator<JMenu>(){

            @Override
            public int compare(JMenu o1, JMenu o2) {
                String title1 = o1.getText();
                String title2 = o2.getText();
                return title1.compareToIgnoreCase(title2);
            }
        });
        return menuList;
    }

    private static final JMenu buildCategoryMenu(ApplicationCategory cat) {
        JMenu menu = new JMenu();
        ApplicationManager mgr = ApplicationManager.getInstance();
        if (mgr == null) {
            return menu;
        }
        ArrayList ids = cat.getApplicationIds();
        for (String id : ids) {
            ApplicationRegistry reg = mgr.getApplicationRegistry(id);
            if (reg == null || !reg.isShownAtApplicationMenu()) continue;
            AbstractAction action = mgr.getApplicationAction(reg);
            menu.add(action);
        }
        menu.setText(mgr.getCategoryName(cat));
        byte[] ic = cat.getIcon();
        if (ic != null) {
            menu.setIcon(new ImageIcon(ic));
        }
        return menu;
    }
}

