/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.actions.AlgorithmCreateAction;
import csbase.client.applications.algorithmsmanager.actions.AlgorithmManagementAction;
import csbase.client.applications.algorithmsmanager.actions.AlgorithmRemoveAction;
import csbase.client.applications.algorithmsmanager.actions.CommonManagementAction;
import csbase.client.applications.algorithmsmanager.actions.ListOutdatedAlgorithmAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmCreateDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmEditDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmListView;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonSelectionPanel;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import csbase.logic.algorithms.AlgorithmInfo;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;

public class AlgorithmSelectionPanel
extends CommonSelectionPanel {
    private AlgorithmListView algorithmListView;
    private int currentAlgorithmRow;
    private AlgorithmCreateAction algorithmCreateAction;
    private AlgorithmRemoveAction algorithmRemoveAction;
    private ListOutdatedAlgorithmAction listOutdatedAlgorithmAction;
    private JPanel mainSelectionPanel;
    private JPanel algoListPanel;
    private boolean infoAlreadyUpdated;
    private boolean isInitialSelection;

    public AlgorithmSelectionPanel(CommonManagementAction action) {
        super(action);
    }

    @Override
    public AlgorithmManagementAction getManagementAction() {
        return (AlgorithmManagementAction)super.getManagementAction();
    }

    @Override
    protected JPanel buildMainSelectionPanel() {
        this.mainSelectionPanel = new JPanel(new GridBagLayout());
        this.algoListPanel = this.getAlgorithmListPanel();
        this.mainSelectionPanel.add((Component)this.algoListPanel, new GBC(0, 0).both().west().insets(0, 0, 0, 0));
        return this.mainSelectionPanel;
    }

    @Override
    protected List<Action> buildOperationActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.algorithmCreateAction = new AlgorithmCreateAction(this, null);
        this.algorithmRemoveAction = new AlgorithmRemoveAction(this, null);
        this.algorithmRemoveAction.setEnabled(false);
        actions.add(this.algorithmCreateAction);
        actions.add(this.algorithmRemoveAction);
        return actions;
    }

    @Override
    public List<DataInterface> getSelectedDataList() {
        List<DataInterface> selectedDataList = new ArrayList<DataInterface>();
        if (this.algorithmListView != null) {
            selectedDataList = this.algorithmListView.getSelectedDataList();
        }
        return selectedDataList;
    }

    @Override
    protected boolean confirmSelectionChanged() {
        boolean confirmed = false;
        if (this.getManagementAction().getEditPanel() != null && this.getManagementAction().getEditPanel().confirmDataChanged()) {
            this.currentAlgorithmRow = this.getListSelectedRow();
            confirmed = true;
        }
        this.infoAlreadyUpdated = true;
        this.algorithmListView.selectAlgorithmIndex(this.currentAlgorithmRow);
        this.infoAlreadyUpdated = false;
        return confirmed;
    }

    private JPanel getAlgorithmListPanel() {
        this.algorithmListView = new AlgorithmListView(this, ((AlgorithmsManager)this.getApplication()).getAllAgorithms());
        return this.algorithmListView.getPanel();
    }

    protected void initAlgorithmSelection(AlgorithmListItem item) {
        if (this.infoAlreadyUpdated) {
            return;
        }
        if (this.isCreationEditionPanel()) {
            if (!this.confirmSelectionChanged()) {
                return;
            }
            this.getManagementAction().updateEditPanel(true);
            ((AlgorithmEditDataPanel)this.getManagementAction().getEditPanel()).changeAlgorithmItemEdition(item);
            this.verifyAndChangeButtonsState();
        }
        if (!this.isInitialSelection && this.changedSelectedAlgorithm() && !this.confirmSelectionChanged()) {
            return;
        }
        this.getManagementAction().updateEditPanel(true);
        ((AlgorithmEditDataPanel)this.getManagementAction().getEditPanel()).changeAlgorithmItemEdition(item);
        this.verifyAndChangeButtonsState();
    }

    private boolean changedSelectedAlgorithm() {
        return this.algorithmListView.getSelectedIndex() != this.currentAlgorithmRow;
    }

    private boolean isCreationEditionPanel() {
        return this.getManagementAction().getEditPanel() instanceof AlgorithmCreateDataPanel;
    }

    public AlgorithmListItem getSelectedAlgorithm() {
        return (AlgorithmListItem)super.getSelectedData();
    }

    private int getListSelectedRow() {
        if (this.algorithmListView != null) {
            return this.algorithmListView.getSelectedIndex();
        }
        return -1;
    }

    private void verifyAndChangeButtonsState() {
        boolean enableAddButton = false;
        enableAddButton = this.algorithmListView.getSelectionCount() <= 1;
        this.enableAction(this.algorithmCreateAction, enableAddButton);
        boolean enableRemoveButton = false;
        enableRemoveButton = this.algorithmListView.getSelectionCount() > 0;
        this.enableAction(this.algorithmRemoveAction, enableRemoveButton);
    }

    public void selectAlgorithm(AlgorithmInfo algoInfo) {
        AlgorithmListItem algorithmItem = this.algorithmListView.getAlgorithmItem(algoInfo);
        this.algorithmListView.selectAlgorithm(algoInfo);
        if (!this.infoAlreadyUpdated) {
            this.initAlgorithmSelection(algorithmItem);
        }
    }

    private void selectAlgorithmIndex(int index) {
        if (index >= 0) {
            this.algorithmListView.selectAlgorithmIndex(index);
        }
    }

    @Override
    protected void handleAlgorithmCreated(AlgorithmInfo algoInfo) {
        this.updateSelectionPanel();
        this.selectAlgorithm(algoInfo);
        AlgorithmVersionInfoPanel versionPanel = ((AlgorithmEditDataPanel)this.getManagementAction().getEditPanel()).getVersionPanel();
        this.getManagementAction().getEditPanel().setSelectedInfoPanel(versionPanel);
    }

    @Override
    protected void handleAlgorithmRemoved(AlgorithmInfo algoInfo) {
        this.updateSelectionPanel();
        this.selectAlgorithmIndex(this.currentAlgorithmRow < this.algorithmListView.getCount() ? this.currentAlgorithmRow : (this.currentAlgorithmRow = this.currentAlgorithmRow - 1));
    }

    @Override
    protected void handleAlgorithmUpdated(AlgorithmInfo algoInfo) {
        this.updateSelectionPanel();
        this.infoAlreadyUpdated = true;
        this.selectAlgorithm(algoInfo);
        this.infoAlreadyUpdated = false;
    }

    private void updateSelectionPanel() {
        this.mainSelectionPanel.remove(this.algoListPanel);
        this.algoListPanel = this.getAlgorithmListPanel();
        this.mainSelectionPanel.add((Component)this.algoListPanel, new GBC(0, 0).both().west().insets(0, 0, 0, 0));
        this.mainSelectionPanel.revalidate();
    }

    public void selectInitialData() {
        this.isInitialSelection = true;
        this.selectAlgorithmIndex(0);
        this.isInitialSelection = false;
    }
}

