/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractVersionTreeNodeAction;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class RemovePlatform
extends AbstractVersionTreeNodeAction {
    private AlgorithmVersionInfo version;
    private String platformName;

    public RemovePlatform(VersionTree tree, AlgorithmVersionInfo version, String platformName) {
        super(tree, LNG.get((String)"algomanager.menu.platform.remove"));
        this.version = version;
        this.platformName = platformName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new RemovePlatformDialog().showRemove();
    }

    private class RemovePlatformDialog {
        private RemovePlatformDialog() {
        }

        public boolean showRemove() {
            String removeTitle = MessageFormat.format(LNG.get((String)"algomanager.title.remove_platform"), RemovePlatform.this.version.getInfo().getName(), RemovePlatform.this.version.getId());
            Object[] options = new Object[]{LNG.get((String)"algomanager.button.remove"), LNG.get((String)"algomanager.button.cancel")};
            int opt = StandardDialogs.showOptionDialog((Component)RemovePlatform.this.getWindow(), (String)removeTitle, (Object)MessageFormat.format(LNG.get((String)"algomanager.msg.confirm.platform_remove"), RemovePlatform.this.platformName), (Object[])options);
            if (opt != 0) {
                return false;
            }
            AlgorithmInfo algo = AlgorithmManagementProxy.removePlatform(RemovePlatform.this.version.getInfo().getId(), RemovePlatform.this.version.getId(), RemovePlatform.this.platformName, RemovePlatform.this.getWindow());
            if (algo == null) {
                StandardErrorDialogs.showErrorDialog(RemovePlatform.this.getWindow(), LNG.get((String)"algomanager.title.error") + " - " + removeTitle, MessageFormat.format(LNG.get((String)"algomanager.error.platform_remove"), RemovePlatform.this.platformName));
                return false;
            }
            return true;
        }
    }
}

