/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.table.column;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.table.column.AbstractCommandsTableColumn;
import csbase.client.desktop.RemoteTask;
import csbase.logic.CommandInfo;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PositionColumn
extends AbstractCommandsTableColumn {
    private static final DefaultTableCellRenderer EDITABLE_CELL_RENDERER = new DefaultTableCellRenderer();

    public PositionColumn(String id, ApplicationRegistry appRegistry) {
        super(Integer.class, id, appRegistry, User.getLoggedUser().isAdmin());
    }

    @Override
    public Object getValue(CommandInfo cmd) {
        return cmd.getGlobalPosition();
    }

    @Override
    public void setValue(final CommandInfo cmd, Object value) {
        int previousPosition = cmd.getGlobalPosition();
        String position = value.toString();
        cmd.setGlobalPosition(position.isEmpty() ? 0 : Integer.parseInt(position) - 1);
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws RemoteException {
                this.setResult(CommandsCache.getInstance().updatePosition(cmd));
            }
        };
        String taskTitle = this.getGenericString("task.command.update.title", new Object[0]);
        String taskMessage = this.getGenericString("task.command.update.message", new Object[0]);
        boolean success = task.execute(null, taskTitle, taskMessage);
        if (!success || !((Boolean)task.getResult()).booleanValue()) {
            cmd.setGlobalPosition(previousPosition);
        }
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        return this.isColumnEditable() ? EDITABLE_CELL_RENDERER : null;
    }

    @Override
    public TableCellEditor createTableCellEditor() {
        JTextField textField = new JTextField();
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent ev) {
                if (!Character.isDigit(ev.getKeyChar()) && ev.getKeyChar() != '\b') {
                    ev.consume();
                }
            }
        });
        textField.setColumns(5);
        return new DefaultCellEditor(textField);
    }

    static {
        EDITABLE_CELL_RENDERER.setIcon(ApplicationImages.ICON_EDITABLE_TABLE_CELL_14);
    }
}

