/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.logic;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.logic.BlockSize;
import csbase.client.applications.fileexchanger.logic.ExchangeMode;

public class FileExchangerConfiguration {
    private ExchangeMode transferMode = ExchangeMode.STREAM;
    private BlockSize blockSize = BlockSize.NORMAL;
    public static final boolean DEFAULT_IMPORT_MULTIPLE_FILES = false;
    private boolean importMultipleFiles = false;
    public static final boolean DEFAULT_IMPORT_DIRECTORIES = false;
    private boolean importDirectories = false;
    public static final boolean DEFAULT_EXPORT_MULTIPLE_FILES = false;
    private boolean exportMultipleFiles = false;
    public static final boolean DEFAULT_EXPORT_DIRECTORIES = false;
    private boolean exportDirectories = false;
    public static final long DEFAULT_MIN_INTERVAL_TO_CHECK_PENDING_TRANSFERS = 100L;
    private long minIntervalToCheckPendingTransfers = 100L;
    public static final long DEFAULT_MAX_INTERVAL_TO_CHECK_PENDING_TRANSFERS = 3000L;
    private long maxIntervalToCheckPendingTransfers = 3000L;
    public static final long DEFAULT_MAX_SIMULTANEOUS_TRANSFERS = 5L;
    private long maxSimultaneousTransfers = 5L;
    public static final long DEFAULT_GUI_UPDATE_INTERVAL = 3000L;
    private long guiUpdateInterval = 3000L;
    private FileExchanger fileExchanger = null;

    public ExchangeMode getTransferMode() {
        return this.transferMode;
    }

    public BlockSize getBlockSize() {
        return this.blockSize;
    }

    public boolean isImportMultipleFiles() {
        return this.importMultipleFiles;
    }

    public boolean isImportDirectories() {
        return this.importDirectories;
    }

    public boolean isExportMultipleFiles() {
        return this.exportMultipleFiles;
    }

    public boolean isExportDirectories() {
        return this.exportDirectories;
    }

    public long getMinIntervalToCheckPendingTransfers() {
        return this.minIntervalToCheckPendingTransfers;
    }

    public long getMaxIntervalToCheckPendingTransfers() {
        return this.maxIntervalToCheckPendingTransfers;
    }

    public long getMaxSimultaneousTransfers() {
        return this.maxSimultaneousTransfers;
    }

    public long getGuiUpdateInterval() {
        return this.guiUpdateInterval;
    }

    public FileExchanger getFileExchanger() {
        return this.fileExchanger;
    }

    public void setBlockSize(BlockSize blockSize) {
        this.blockSize = blockSize;
    }

    public void setTransferMode(ExchangeMode transferMode) {
        this.transferMode = transferMode;
    }

    public FileExchangerConfiguration(FileExchanger fileExchanger) {
        this.fileExchanger = fileExchanger;
        if (fileExchanger != null) {
            this.importMultipleFiles = fileExchanger.getBooleanSpecificProperty("importMultipleFiles", false);
            this.importDirectories = fileExchanger.getBooleanSpecificProperty("importDirectories", false);
            this.exportMultipleFiles = fileExchanger.getBooleanSpecificProperty("exportMultipleFiles", false);
            this.exportDirectories = fileExchanger.getBooleanSpecificProperty("exportDirectories", false);
            this.minIntervalToCheckPendingTransfers = fileExchanger.getLongSpecificProperty("minIntervalToCheckPendingTransfers", 100L);
            this.maxIntervalToCheckPendingTransfers = fileExchanger.getLongSpecificProperty("maxIntervalToCheckPendingTransfers", 3000L);
            this.maxSimultaneousTransfers = fileExchanger.getLongSpecificProperty("maxSimultaneousTransfers", 5L);
            this.guiUpdateInterval = fileExchanger.getLongSpecificProperty("guiUpdateInterval", 3000L);
        }
    }
}

