/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlock;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlockType;
import csbase.exception.PermissionException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class ProjectsManagerUI {
    public static final ImageIcon ALLOCATED_BLOCKED = ProjectsManagerUI.getImageIcon("allocated.blocked.16.gif");
    public static final ImageIcon ALLOCATED_FREE = ProjectsManagerUI.getImageIcon("allocated.free.16.gif");
    public static final ImageIcon NO_ALLOCATION = ProjectsManagerUI.getImageIcon("no.allocation.16.gif");
    public static final ImageIcon DEALLOCATED = ProjectsManagerUI.getImageIcon("deallocated.16.gif");
    public static final ImageIcon ALLOCATE = ProjectsManagerUI.getImageIcon("allocate.16.gif");
    public static final ImageIcon WAITING_DEALLOCATION = ProjectsManagerUI.getImageIcon("waiting_deallocation.16.gif");
    public static final ImageIcon ADD_SHARED = ProjectsManagerUI.getImageIcon("add_shared.16.gif");
    public static final ImageIcon REMOVE_SHARED = ProjectsManagerUI.getImageIcon("remove_shared.16.gif");
    public static final ImageIcon DEFINE_USERS = ProjectsManagerUI.getImageIcon("define_users.16.gif");
    public static final ImageIcon DISK_USE = ProjectsManagerUI.getImageIcon("disk_use.16.gif");
    private static final String TAG_SEPARATOR = ".";
    private static final String ID = "projectsmanager";

    public static void addAutomaticHistoryBlock(CommonClientProject commonClientProject, ProjectHistoryBlockType blockType) throws RemoteException {
        ProjectHistoryBlock phb = new ProjectHistoryBlock(blockType);
        ArrayList<User> users = new ArrayList<User>();
        if (blockType.equals((Object)ProjectHistoryBlockType.PROJECT_SHARED)) {
            for (Object id : commonClientProject.getUserIdsSet()) {
                users.add(User.getUser(id));
            }
            phb.setUsers(users);
        }
        try {
            ClientProjectFile projectFile = commonClientProject.getRoot();
            projectFile.appendDescription(phb.getHistoryBlock());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String generateSizeStringFromDouble(double num) {
        String str;
        if (num < 0.0) {
            return "";
        }
        if (num < 1.0) {
            double d = (double)Math.round(num * 1000.0 * 1000.0) / 1000.0;
            str = String.valueOf(d) + " kb";
        } else if (num < 1000.0) {
            double d = num;
            str = String.valueOf(d) + " mb";
        } else {
            double d = num / 1000.0;
            str = String.valueOf(d) + " gb";
        }
        return str;
    }

    private static final ImageIcon getImageIcon(String path) {
        return ProjectsManager.getImageIcon(ProjectsManager.class, path);
    }

    public static final String getClassString(Class<?> theClass, String tag) {
        String classPrefix = theClass.getSimpleName();
        String theTag = classPrefix + TAG_SEPARATOR + tag;
        ApplicationManager mgr = ApplicationManager.getInstance();
        ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
        return reg.getString(theTag);
    }

    public static final String getString(String tag) {
        ApplicationManager mgr = ApplicationManager.getInstance();
        ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
        return reg.getString(tag);
    }

    public static void handleException(ProjectsManager projectsManager, Exception e) {
        if (e instanceof PermissionException) {
            return;
        }
        projectsManager.showException(projectsManager.getName(), e);
    }

    public static final boolean hasClassString(Class<?> theClass, String tag) {
        String classPrefix = theClass.getSimpleName();
        String theTag = classPrefix + TAG_SEPARATOR + tag;
        ApplicationManager mgr = ApplicationManager.getInstance();
        ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
        return reg.hasString(theTag);
    }

    public static final boolean hasString(String tag) {
        ApplicationManager mgr = ApplicationManager.getInstance();
        ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
        return reg.hasString(tag);
    }

    public static boolean isEmptyString(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().isEmpty();
    }
}

