/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v2.eventlog;

import csbase.client.csdk.v2.core.CSDKAbstractContext;
import csbase.client.csdk.v2.eventlog.CSDKLogsInfo;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.logic.eventlogservice.LogsInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.EventLogServiceInterface;
import csdk.v2.extras.context.EventLogException;
import csdk.v2.extras.context.IEventLogContext;
import csdk.v2.extras.context.ILogsInfo;
import java.util.Date;
import tecgraf.javautils.core.lng.LNG;

public class CSDKEventLogContext
extends CSDKAbstractContext
implements IEventLogContext {
    public ILogsInfo find(final String[][] queues, final Date startDate, final Date endDate) throws EventLogException {
        if (!ClientRemoteMonitor.getInstance().isAlive()) {
            throw new EventLogException(LNG.get((String)"eventlog.msg.no_server"));
        }
        final EventLogServiceInterface eventLogService = ClientRemoteLocator.eventLogService;
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        if (mainFrame == null || eventLogService == null) {
            throw new EventLogException(LNG.get((String)"eventlog.msg.no_server"));
        }
        RemoteTask<ILogsInfo> task = new RemoteTask<ILogsInfo>(){

            public void performTask() throws Exception {
                LogsInfo info = eventLogService.find(queues, startDate, endDate);
                this.setResult(new CSDKLogsInfo(info));
            }
        };
        String msg = LNG.get((String)"eventlog.msg.reading_data");
        String title = LNG.get((String)"eventlog.title");
        if (task.execute(mainFrame.getDesktopFrame(), title, msg)) {
            return (ILogsInfo)task.getResult();
        }
        return new CSDKLogsInfo(new LogsInfo(startDate, endDate));
    }
}

