/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.desktop.DesktopFrame;
import csbase.client.openbus.OpenBusApplicationInstanceData;
import csbase.client.openbus.OpenBusEventHandler;
import csbase.client.openbus.OpenBusStandardEvents;
import csbase.logic.CommonClientProject;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.rmi.RemoteException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class DesktopFrameOpenBusEventHandler
extends OpenBusEventHandler {
    private final DesktopFrame desktop;
    private Boolean isOnShutdownByRequest = false;

    protected final void fireDesktopVisibilityInfo(boolean shown) {
        String fatherId = this.getFatherClientInstanceId();
        OpenBusStandardEvents ev = OpenBusStandardEvents.DESKTOP_VISIBILITY_INFO;
        ev.sendEvent(this, fatherId, shown);
    }

    protected final boolean fireInsideApplication(String sourceId, String appId) {
        ApplicationManager appManager = ApplicationManager.getInstance();
        ApplicationRegistry reg = appManager.getApplicationRegistry(appId);
        if (reg == null) {
            return false;
        }
        try {
            Object appInstance = appManager.runApplication(appId);
            OpenBusStandardEvents okType = OpenBusStandardEvents.APP_EXECUTION_SUCCESS_RSP;
            OpenBusApplicationInstanceData data = new OpenBusApplicationInstanceData(appId, (ApplicationType)appInstance);
            String stringValue = data.getEventValue();
            okType.sendEvent(this, sourceId, stringValue);
            return true;
        }
        catch (ApplicationException e) {
            OpenBusStandardEvents okType = OpenBusStandardEvents.APP_EXECUTION_FAILURE_RSP;
            okType.sendEvent(this, sourceId, appId);
            return false;
        }
    }

    protected final boolean firePrjOpenFailedRsp(String destId, String stringValue) {
        String errMsg = this.getString("project.remote.open.error");
        String failedMsg = errMsg + ": " + stringValue;
        this.desktop.displayTrayErrorMessage(failedMsg);
        OpenBusStandardEvents ev = OpenBusStandardEvents.PRJ_OPEN_FAILED_RSP;
        return ev.sendEvent(this, destId, stringValue);
    }

    protected final boolean firePrjOpenSuccessRsp(String destId, String stringValue) {
        OpenBusStandardEvents ev = OpenBusStandardEvents.PRJ_OPEN_SUCCESS_RSP;
        return ev.sendEvent(this, destId, stringValue);
    }

    private final String getString(String tag) {
        String className = this.getClass().getSimpleName();
        String formattedTag = className + "." + tag;
        return LNG.get((String)formattedTag);
    }

    private boolean handleDesktopShutdownReq(String sourceId) {
        Client client = Client.getInstance();
        String fatherId = client.getFatherClientInstanceId();
        if (sourceId.equals(fatherId)) {
            this.setShutDownByRequest();
            this.desktop.shutdownDesktop();
        }
        return true;
    }

    private boolean handleDesktopVisibilityReq(boolean flag) {
        this.desktop.setDesktopVisible(flag);
        if (!flag) {
            Client client = Client.getInstance();
            this.desktop.displayTrayInfoMessage(client.getSystemName());
        }
        return true;
    }

    private boolean handleLauncherEndInfo(String sourceId) {
        Client client = Client.getInstance();
        String fatherId = client.getFatherClientInstanceId();
        if (sourceId.equals(fatherId)) {
            System.out.println("Father died!");
        }
        return true;
    }

    private boolean handlePrjOpenReq(String sourceId, String stringValue) {
        CommonClientProject prj;
        String[] splitted = stringValue.split("::");
        if (splitted == null || splitted.length != 2) {
            return this.firePrjOpenFailedRsp(sourceId, stringValue);
        }
        String userId = splitted[0];
        String projectName = splitted[1];
        String projectId = userId + "/" + projectName;
        try {
            prj = CommonClientProject.openProject((Object)projectId, (boolean)true);
            boolean changed = this.setCurrentProject(prj);
            if (!changed) {
                return this.firePrjOpenFailedRsp(sourceId, stringValue);
            }
        }
        catch (RemoteException e) {
            return this.firePrjOpenFailedRsp(sourceId, stringValue);
        }
        if (prj == null) {
            return this.firePrjOpenFailedRsp(sourceId, stringValue);
        }
        return this.firePrjOpenSuccessRsp(sourceId, stringValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Boolean isOnShutdownByRequest() {
        Boolean bl = this.isOnShutdownByRequest;
        synchronized (bl) {
            return this.isOnShutdownByRequest;
        }
    }

    @Override
    public boolean receiveEventWithBooleanValue(String sourceId, String destId, String type, boolean booleanValue) {
        if (!this.isEventFromFatherAndToMe(sourceId, destId)) {
            return false;
        }
        if (OpenBusStandardEvents.DESKTOP_VISIBILITY_REQ.isMyType(type)) {
            return this.handleDesktopVisibilityReq(booleanValue);
        }
        return false;
    }

    @Override
    public boolean receiveEventWithNoValue(String sourceId, String destId, String type) {
        if (!this.isEventFromFatherAndToMe(sourceId, destId)) {
            return false;
        }
        OpenBusStandardEvents launcherEndType = OpenBusStandardEvents.DSKLAUNCHER_END_INFO;
        if (launcherEndType.isMyType(type)) {
            return this.handleLauncherEndInfo(sourceId);
        }
        OpenBusStandardEvents shutdownType = OpenBusStandardEvents.DESKTOP_SHUTDOWN_REQ;
        if (shutdownType.isMyType(type)) {
            return this.handleDesktopShutdownReq(sourceId);
        }
        return false;
    }

    @Override
    public boolean receiveEventWithStringValue(String sourceId, String destId, String type, String stringValue) {
        if (!this.isEventFromFatherAndToMe(sourceId, destId)) {
            return false;
        }
        if (OpenBusStandardEvents.APP_EXECUTION_REQ.isMyType(type)) {
            String appId = stringValue;
            return this.fireInsideApplication(sourceId, appId);
        }
        if (OpenBusStandardEvents.PRJ_OPEN_REQ.isMyType(type)) {
            return this.handlePrjOpenReq(sourceId, stringValue);
        }
        return false;
    }

    private boolean setCurrentProject(final CommonClientProject prj) {
        try {
            SwingThreadDispatcher.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    DesktopFrameOpenBusEventHandler.this.desktop.setCurrentProject(prj);
                }
            });
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setShutDownByRequest() {
        Boolean bl = this.isOnShutdownByRequest;
        synchronized (bl) {
            this.isOnShutdownByRequest = true;
        }
    }

    public void shutdown() {
        if (!this.isOnShutdownByRequest().booleanValue()) {
            OpenBusStandardEvents type = OpenBusStandardEvents.DESKTOP_END_INFO;
            String fatherId = this.getFatherClientInstanceId();
            type.sendEvent(this, fatherId, null);
        }
    }

    public DesktopFrameOpenBusEventHandler(DesktopFrame desktop) {
        this.desktop = desktop;
        OpenBusStandardEvents type = OpenBusStandardEvents.DESKTOP_START_INFO;
        String fatherId = this.getFatherClientInstanceId();
        type.sendEvent(this, fatherId, null);
    }
}

