/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences;

import csbase.client.preferences.DefinitionLoader;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceException;
import csbase.client.preferences.PreferencePersistence;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.util.PreferencesUtil;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Window;

public class PreferenceManager {
    private static PreferenceManager instance;
    private PreferenceCategory root;
    private boolean alreadyLoaded = false;
    private DefinitionLoader loader = DefinitionLoader.getInstance();
    private PreferencePersistence persistence = PreferencePersistence.getInstance();

    public static PreferenceManager getInstance() {
        if (instance == null) {
            instance = new PreferenceManager();
        }
        return instance;
    }

    public PreferenceCategory loadPreferences() {
        return this.loadPreferences(null);
    }

    public PreferenceCategory loadPreferences(Window parent) {
        if (!this.alreadyLoaded) {
            try {
                this.persistence.load(parent, this.root);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alreadyLoaded = true;
        }
        return this.root;
    }

    public void savePreferences() {
        this.savePreferences(null);
    }

    public void savePreferences(Window parent) {
        if (!this.alreadyLoaded) {
            throw new PreferenceException("N\u00e3o \u00e9 poss\u00edvel salvar antes da carga das prefer\u00eancias do usu\u00e1rio.");
        }
        this.persistence.save(parent, this.root);
    }

    public PreferenceCategory loadAppPreferences(ApplicationRegistry registry, Window parent) {
        PreferenceCategory root = this.loadPreferences(parent);
        Class<? extends PreferenceDefinition> enumClass = this.loader.loadAppEnum(registry);
        return root.getCategory(enumClass);
    }

    public boolean hasAppPreferences(ApplicationRegistry registry) {
        return this.loader.loadAppEnum(registry) != null;
    }

    public void loadDefinition(Class<? extends PreferenceDefinition> enumClass) {
        if (this.alreadyLoaded) {
            throw new PreferenceException("N\u00e3o \u00e9 poss\u00edvel carregar uma defini\u00e7\u00e3o ap\u00f3s as prefer\u00eancias do usu\u00e1rio terem sido carregadas.");
        }
        this.loader.loadDefinition(this.root, enumClass);
    }

    public void setDefaultValue(PreferenceDefinition name, String defaultValue) {
        if (this.alreadyLoaded) {
            throw new PreferenceException("N\u00e3o \u00e9 poss\u00edvel modificar o valor default ap\u00f3s as prefer\u00eancias do usu\u00e1rio terem sido carregadas.");
        }
        PreferenceCategory pc = PreferencesUtil.deepSearch(name, this.root);
        PreferenceValue<?> preference = pc.getPreference(name);
        preference.setDefaultValueAsStr(defaultValue);
        preference.setValueAsStr(defaultValue);
    }

    private PreferenceManager() {
        this.root = new PreferenceCategory(PreferenceCategory.ROOT_ID, this.loader.getGeneralBundle());
        this.loader.loadAppDefinitions(this.root);
    }
}

