/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.FilePropertiesDialog;
import csbase.client.util.MetalThemeAdapter;
import csbase.logic.User;
import csbase.logic.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import tecgraf.javautils.core.lng.LNG;

public class AppendDescriptionDialog {
    private DesktopComponentDialog descriptionDialog;
    private JButton closeButton;
    private JTextArea description;
    private FilePropertiesDialog owner;

    public AppendDescriptionDialog(FilePropertiesDialog owner) {
        this.owner = owner;
        this.descriptionDialog = this.makeDialog();
    }

    private DesktopComponentDialog makeDialog() {
        JDialog dlg = this.owner.getDialog();
        String title = LNG.get((String)"PRJ_FILE_ADD_DESCRIPTION");
        DesktopComponentDialog aDialog = new DesktopComponentDialog((Window)dlg, title);
        aDialog.setModal(true);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.makeFieldPanel());
        mainPanel.add(this.makeButtonPanel(), "South");
        aDialog.getContentPane().add(mainPanel);
        aDialog.pack();
        aDialog.center(dlg);
        aDialog.getRootPane().setDefaultButton(this.closeButton);
        return aDialog;
    }

    private Component makeButtonPanel() {
        JPanel panel = new JPanel();
        JButton addButton = new JButton(LNG.get((String)"PRJ_FILE_ADD"));
        panel.add(addButton);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppendDescriptionDialog.this.addDescription();
            }
        });
        this.closeButton = new JButton(LNG.get((String)"UTIL_CLOSE"));
        panel.add(this.closeButton);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppendDescriptionDialog.this.descriptionDialog.close();
            }
        });
        return panel;
    }

    private void addDescription() {
        String date = Utilities.getFormattedDate((long)new Date().getTime());
        String userLogin = User.getLoggedUser().getLogin();
        String userName = User.getLoggedUser().getName();
        MessageFormat formatter = new MessageFormat(LNG.get((String)"PRJ_FILE_MSG_SAVED_DESCRIPTION"));
        String message = this.description.getText().trim();
        Object[] arg = new Object[]{date, userLogin, userName, message};
        message = formatter.format(arg);
        this.appendFileDescription(message);
        this.owner.updateDescription();
        this.descriptionDialog.close();
    }

    private void appendFileDescription(final String message) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                AppendDescriptionDialog.this.owner.getFile().appendDescription(message);
            }
        };
        task.execute(this.owner.getDialog(), this.owner.getTitle(), LNG.get((String)"PRJ_FILE_ADD_DESCRIPTION_TASK_MSG"));
    }

    private Component makeFieldPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(8, 10, 10, 3);
        c.fill = 0;
        c.anchor = 17;
        JLabel instruction = new JLabel("Por favor, entre com a descri\u00e7\u00e3o desejada:");
        instruction.setBackground(MetalThemeAdapter.getInstance().getSecondary3());
        panel.add((Component)instruction, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 8;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(3, 10, 10, 8);
        c.fill = 1;
        c.anchor = 17;
        this.description = new JTextArea(8, 30);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setBorder(new BevelBorder(1));
        JScrollPane scrollPane = new JScrollPane(this.description);
        panel.add((Component)scrollPane, c);
        return panel;
    }

    public void setVisible(boolean visible) {
        this.descriptionDialog.setVisible(visible);
    }
}

