/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.applications.ApplicationImages;
import csbase.client.project.ProjectTableModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.table.SortableTable;

public class ProjectTableSortableTable
extends SortableTable {
    public ProjectTableSortableTable(List<ProjectTableModel.RowData> projects, ProjectTableModel.VisibleColumns visibleColumns) {
        super((TableModel)new ProjectTableModel(projects, visibleColumns));
        this.setSelectionMode(0);
        this.setRowSelectionAllowed(true);
        this.setFillsViewportHeight(true);
        this.setDefaultRenderer(Boolean.class, this.createBooleanRenderer());
    }

    public ProjectTableModel.RowData getSelectedRowData() {
        ProjectTableModel model = (ProjectTableModel)this.getModel();
        return model.getRow(this.convertRowIndexToModel(this.getSelectedRow()));
    }

    public void setNewValues(List<ProjectTableModel.RowData> projectList) {
        ProjectTableModel model = (ProjectTableModel)this.getModel();
        model.replaceRows(projectList);
    }

    public void setVisibleColumns(ProjectTableModel.VisibleColumns visibleColumns) {
        ProjectTableModel model = (ProjectTableModel)this.getModel();
        model.setVisibleColumns(visibleColumns);
        if (visibleColumns == ProjectTableModel.VisibleColumns.OWNER_NAME_PERMISSION) {
            TableColumn column = this.getColumnModel().getColumn(this.getColumnCount() - 1);
            column.setMaxWidth(50);
        }
    }

    public void setSelectedFirstRow() {
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 0);
        }
    }

    private TableCellRenderer createBooleanRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setHorizontalAlignment(0);
                if (value == null) {
                    this.setText("ERROR");
                    return this;
                }
                if (((Boolean)value).booleanValue()) {
                    this.setIcon(ApplicationImages.ICON_OK_16);
                } else {
                    this.setIcon(null);
                }
                return this;
            }
        };
    }
}

