/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.xmlpanel.xmltagtreepanel;

import csbase.client.util.xmlpanel.XMLAbstractPanel;
import csbase.client.util.xmlpanel.XMLPanelNodeSelectionListener;
import csbase.client.util.xmlpanel.XMLPanelStyleInterface;
import csbase.client.util.xmlpanel.xmltagtreepanel.XMLTagTreeModel;
import csbase.client.util.xmlpanel.xmltagtreepanel.XMLTagTreeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTagTreePanel
extends XMLAbstractPanel {
    private final JTree jtree = new JTree();

    public void addSelectionListener(final XMLPanelNodeSelectionListener nsl) {
        this.jtree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                nsl.nodeSelected(XMLTagTreePanel.this.getSelectedNode());
            }
        });
    }

    public Node getSelectedNode() {
        Object object = this.jtree.getLastSelectedPathComponent();
        return (Node)object;
    }

    @Override
    public void setNode(Node node) {
        TreePath pth;
        this.internalSetNode(node);
        XMLTagTreeModel model = new XMLTagTreeModel(node);
        this.jtree.setModel(model);
        if (node != null && (pth = this.getTreePath(node)) != null) {
            this.jtree.expandPath(pth);
        }
    }

    public void setSelectedNode(Node node) {
        TreePath pth;
        if (node == null) {
            return;
        }
        for (Node expNode = node; expNode != null; expNode = expNode.getParentNode()) {
            pth = this.getTreePath(expNode);
            if (pth == null) continue;
            this.jtree.expandPath(pth);
        }
        pth = this.getTreePath(node);
        this.jtree.setSelectionPath(pth);
        this.jtree.scrollPathToVisible(pth);
    }

    private TreePath getTreePath(TreePath path, Node node) {
        Node pathNode = (Node)path.getLastPathComponent();
        if (pathNode == node) {
            return path;
        }
        NodeList childNodes = pathNode.getChildNodes();
        int numChildren = childNodes.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node n = childNodes.item(i);
            TreePath pth = path.pathByAddingChild(n);
            TreePath tpath = this.getTreePath(pth, node);
            if (tpath == null) continue;
            return tpath;
        }
        return null;
    }

    private TreePath getTreePath(Node node) {
        TreeModel model = this.jtree.getModel();
        Node root = (Node)model.getRoot();
        TreePath rootPath = new TreePath(root);
        TreePath tpath = this.getTreePath(rootPath, node);
        return tpath;
    }

    public XMLPanelStyleInterface getStyle() {
        XMLTagTreeRenderer rnd = (XMLTagTreeRenderer)this.jtree.getCellRenderer();
        return rnd.getStyle();
    }

    public void setStyle(XMLPanelStyleInterface style) {
        XMLTagTreeRenderer rnd = (XMLTagTreeRenderer)this.jtree.getCellRenderer();
        rnd.setStyle(style);
    }

    public XMLTagTreePanel() {
        this.jtree.setModel(new XMLTagTreeModel(null));
        this.jtree.setCellRenderer(new XMLTagTreeRenderer());
        this.jtree.setShowsRootHandles(true);
        TreeSelectionModel selectionModel = this.jtree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.jtree);
        this.add((Component)scrollPane, "Center");
    }
}

