package csbase.client.applications.pdfviewer.actions;

import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.ImageIcon;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.pdfviewer.PDFViewer;
import csbase.logic.ClientFile;

/**
 * Classe abstrata que  base para aes de abrir arquivo
 * 
 * @author Tecgraf
 */
public abstract class AbstractOpenPdfFileAction extends
  AbstractSimpleApplicationAction<PDFViewer> {

  /**
   * Construtor padro.
   * 
   * @param application aplicao.
   * @param icon icone de abertura de arquivo
   */
  public AbstractOpenPdfFileAction(PDFViewer application, ImageIcon icon) {
    super(application, icon);
  }

  /**
   * Escolhe um arquivo ou retorna nulo caso nenhum arquivo tenha sido escolhido
   * 
   * @return clientFile escolhido ou nulo caso nenhum arquivo tenha sido
   *         escolhido
   */
  protected abstract ClientFile chooseClientFileOrNull();

  /**
   * Retorna uma lista de extenses de tipo de arquivo, para ser utilizada com o
   * Client*FileChooserUtil.browseSingleFileInOpenMode
   * 
   * @return uma lista de extenses de tipo de arquivo, para ser utilizada com o
   *         Client*FileChooserUtil.browseSingleFileInOpenMode
   */
  List<String> getProjectFileExtensions() {
    return getApplication().getFileTypes();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    final ClientFile clientFile = chooseClientFileOrNull();
    if (clientFile != null) {
      getApplication().openPdfFile(clientFile);
    }
  }
}
