/*
 * $Id:$
 */

package csbase.client.applications.xmlviewer.actions;

import java.util.List;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.xmlviewer.XMLViewer;
import csbase.client.applications.xmlviewer.actions.core.XMLViewerAbstractOpenAction;
import csbase.logic.ClientFile;

/**
 * Ao de carregar um relatrio da rea de local.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class XMLViewerProjectOpenAction extends XMLViewerAbstractOpenAction {

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public XMLViewerProjectOpenAction(XMLViewer application) {
    super(application, ApplicationImages.ICON_OPEN_16);
  }

  /**
   * Mtodo inteno de busca de arquivo.
   * 
   * @return um objeto <code>ClientProjectFile</code> ou <code>null</code>.
   * @throws Exception em caso de erro.
   */
  @Override
  final protected ClientFile getFileForOpen() throws Exception {
    final XMLViewer application = getApplication();
    final List<String> fileCodes = application.getFileTypes();
    final String[] fileTypes = fileCodes.toArray(new String[fileCodes.size()]);
    return application.browseFileOpen(fileTypes, fileTypes[0]);
  }

}
