package csbase.client.applications.projectsmanager.models;

/**
 * Estrutura que armazena informaes de ocupao de projetos na rea de
 * projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectGeneralAreaOccupationData {

  /**
   * Espao livre na rea de projetos.
   */
  private double freeSpace;

  /**
   * Espao ocupado na rea de projetos.
   */
  private double occupiedSpace;

  /**
   * Construtor
   * 
   * @param freeSpace Espao livre na rea de projetos.
   * @param occupiedSpace Espao ocupado na rea de projetos.
   */
  public ProjectGeneralAreaOccupationData(final double freeSpace,
    final double occupiedSpace) {
    this.freeSpace = freeSpace;
    this.occupiedSpace = occupiedSpace;
  }

  /**
   * Retorna espao livre na rea de projetos.
   * 
   * @return Espao livre na rea de projetos.
   */
  public double getFreeSpace() {
    return freeSpace;
  }

  /**
   * Retorna espao ocupado na rea de projetos.
   * 
   * @return Espao ocupado na rea de projetos.
   */
  public double getOccupiedSpace() {
    return occupiedSpace;
  }

}
