package csbase.client.project.action;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.logic.ClientProjectFile;
import csbase.remote.ClientRemoteLocator;

/**
 * Classe responsvel pela ao de desbloqueio de um arquivo. Operao s
 * permitida pelo administrador. A motivao desse comportamento  que podem
 * existir algumas situaes em que o arquivo fica indefinidamente bloqueado.
 * Esta ao reverte o estado do arquivo. Este  um item de menu avanado e o
 * administrador deve ser avisado do impacto de tal alterao.
 */
public class FileUnlockAction extends CommonProjectAction {

  /**
   * Construtor.
   * 
   * @param container o container do projeto
   */
  public FileUnlockAction(ProjectFileContainer container) {
    super(container);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final ClientProjectFile file = getSelectedFile();
    String fileName = file.getName();
    String title = LNG.get("FileUnlockAction.title");
    String text =
      String.format(LNG.get("FileUnlockAction.confirmation"), fileName);

    int option =
      StandardDialogs.showOptionDialog(
        getWindow(),
        title,
        text,
        new String[] { LNG.get("FileUnlockAction.button.unlock"),
            LNG.get("FileUnlockAction.button.cancel") });

    if (option != 0) {
      return;
    }

    RemoteTask<Integer> task = new RemoteTask<Integer>() {
      @Override
      protected void performTask() throws Exception {
        setResult(ClientRemoteLocator.projectService.forceReleaseLock(
          file.getProjectId(), file.getPath()));
      }
    };

    boolean result =
      task.execute(getWindow(), title,
        String.format(LNG.get("FileUnlockAction.info.unlock"), fileName));
    if (result && (task.getResult() != 0)) {
      showError(title,
        String.format(LNG.get("FileUnlockAction.error.unlock"), fileName));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return LNG.get("FileUnlockAction.name");
  }

}
