package csbase.client.util.gui.log.tab;

import java.awt.Component;

import csbase.client.kernel.ClientException;
import csbase.client.util.gui.log.tab.AbstractTab.TabType;

/**
 * Interface para abas de visualizao de comandos.
 */
public interface Tab {

  /**
   * Retorna o ttulo da aba.
   *
   * @return O ttulo da aba.
   */
  public abstract String getTitle();

  /**
   * Determina se esta aba est selecionada.
   *
   * @param selected Verdadeiro se a aba est selecionada ou falso, caso
   *        contrrio.
   */
  public abstract void setSelected(boolean selected);

  /**
   * Indica se a aba est selecionada.
   *
   * @return Verdadeiro se a aba est selecionada ou falso, caso contrrio.
   */
  public abstract boolean isSelected();

  /**
   * Obtm o tipo ({@link TabType}) da aba.
   *
   * @return o tipo da aba.
   */
  public abstract TabType getType();

  /**
   * Retorna o principal componente visual da aba, a ser anexado na visualizao
   * do comando.
   *
   * @return o componente principal.
   * @throws ClientException em caso de erro na criao da viso da aba.
   */
  public abstract Component getMainComponent() throws ClientException;

}