/*
 * $Id$
 */
package csbase.client.util.table;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.client.applications.ApplicationImages;

/**
 * @author Tecgraf / PUC-Rio
 * 
 * <p>
 * Esta classe modela um renderizador de clulas de tabela que tem como
 * caracterstica adicionar o cone de um lpis nas clulas editveis.<br>
 * </p>
 * <p>
 * Pode-se adicionar um renderizador a uma clula de duas formas:
 * <ul>
 * <li> Adicionando a coluna a qual aquela clula pertence. Para isso deve-se:<br>
 * <ol>
 * <li>Pegar o modelo de colunas da tabela atravs do mtodo
 * {@link JTable#getColumnModel()} </li>
 * <li>Com o modelo conseguimos a coluna com o mtodo
 * {@link javax.swing.table.TableColumnModel#getColumn(int)}</li>
 * <li>Tendo a coluna, atribuimos o renderizador usando o mtodo
 * {@link  javax.swing.table.TableColumn#setCellRenderer(javax.swing.table.TableCellRenderer)}</li>
 * </ol>
 * </li>
 * <li> Adicionando como renderizador padro das clulas da tabela atravs do
 * mtodo
 * {@link JTable#setDefaultRenderer(Class, javax.swing.table.TableCellRenderer)}.
 * </li>
 * </ul>
 * Este renderizador pode ser adicionado a uma coluna especfica de uma tabela
 * ou
 */
public class EditableCellRenderer extends DefaultTableCellRenderer {

  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {

    if (table.getModel().isCellEditable(row, column)) {
      setIcon(ApplicationImages.ICON_EDITABLE_TABLE_CELL_14);
    }
    else {
      setIcon(null);
    }
    return super.getTableCellRendererComponent(table, value, isSelected,
      hasFocus, row, column);
  }
}
