/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms;

import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.kernel.ClientException;
import csbase.client.util.DateTableCellRenderer;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.HistoryProvider;
import csbase.logic.algorithms.HistoryRecord;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.table.SortableTable;

public final class ShowHistoryAction
extends AbstractAction {
    private DesktopComponentDialog dialog;
    private Window ownerWindow;
    private HistoryProvider historyProvider;
    private SortableTable table;

    public ShowHistoryAction(Window ownerWindow) {
        this(null, ownerWindow);
    }

    public ShowHistoryAction(HistoryProvider provider, Window ownerWindow) {
        this(provider);
        this.ownerWindow = ownerWindow;
    }

    public ShowHistoryAction(HistoryProvider provider) {
        super(LNG.get((String)(ShowHistoryAction.class.getName() + ".name")), ApplicationImages.ICON_HISTORY_24);
        this.historyProvider = provider;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.showDialog();
        }
        catch (ClientException ex) {
            StandardErrorDialogs.showErrorDialog(this.ownerWindow, ex.getMessage());
        }
    }

    private final void showDialog() throws ClientException {
        String path = this.historyProvider == null ? "" : this.historyProvider.getName();
        String title = MessageFormat.format(LNG.get((String)(ShowHistoryAction.class.getName() + ".title")), path);
        this.dialog = new DesktopComponentDialog(this.ownerWindow, title);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ShowHistoryAction.this.closeDialog();
            }
        });
        this.dialog.getContentPane().add(this.makeContentPane());
        int FRAME_WIDTH = 800;
        int FRAME_HEIGHT = this.dialog.getContentPane().getPreferredSize().height;
        this.dialog.setSize(800, FRAME_HEIGHT);
        int FRAME_INTERNAL_MARGIN = 13;
        this.table.setPreferredScrollableViewportSize(new Dimension(787, this.table.getPreferredScrollableViewportSize().height));
        if (this.ownerWindow != null) {
            this.dialog.center(this.ownerWindow);
        }
        this.dialog.setVisible(true);
    }

    private Container makeContentPane() throws ClientException {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.makeTopPanel(), "North");
        panel.add((Component)new JScrollPane(this.makeTable()), "Center");
        panel.add((Component)this.makeButtonPanel(), "South");
        return panel;
    }

    private Container makeTopPanel() {
        JLabel pathLbl = new JLabel(LNG.get((String)(ShowHistoryAction.class.getName() + ".pathLabel")));
        String path = this.historyProvider == null ? "" : this.historyProvider.getName();
        JTextField pathText = new JTextField(path);
        pathText.setBackground(this.dialog.getBackground());
        pathText.setEditable(false);
        JComponent[][] row = new JComponent[][]{{pathLbl, pathText}};
        return GUIUtils.createBasicGridPanel((JComponent[][])row);
    }

    private JTable makeTable() throws ClientException {
        List rows;
        List list = rows = this.historyProvider == null ? new ArrayList() : this.historyProvider.getHistory();
        if (rows == null) {
            throw new ClientException(LNG.get((String)(ShowHistoryAction.class.getName() + ".error")));
        }
        HistoryTableModel m = new HistoryTableModel(rows);
        this.table = new SortableTable((TableModel)m);
        this.table.sort(0, SortOrder.DESCENDING);
        this.table.setDefaultRenderer(Date.class, (TableCellRenderer)new DateTableCellRenderer());
        this.table.adjustColumnWidth();
        return this.table;
    }

    private Container makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton(LNG.get((String)(ShowHistoryAction.class.getName() + ".closeButton")));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowHistoryAction.this.closeDialog();
            }
        });
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    private final void closeDialog() {
        this.dialog.dispose();
    }

    public HistoryProvider getHistoryProvider() {
        return this.historyProvider;
    }

    public void setHistoryProvider(HistoryProvider provider) {
        this.historyProvider = provider;
    }

    private class HistoryTableModel
    extends AbstractTableModel {
        private final List recordList;
        private final String[] columnNames = new String[]{LNG.get((String)(ShowHistoryAction.class.getName() + ".dateColumn")), LNG.get((String)(ShowHistoryAction.class.getName() + ".pathColumn")), LNG.get((String)(ShowHistoryAction.class.getName() + ".loginColumn")), LNG.get((String)(ShowHistoryAction.class.getName() + ".nameColumn")), LNG.get((String)(ShowHistoryAction.class.getName() + ".descriptionColumn"))};
        private final Class[] columnClasses = new Class[]{Date.class, String.class, String.class, String.class, String.class};

        public HistoryTableModel(List recordList) {
            this.recordList = recordList;
        }

        @Override
        public int getRowCount() {
            return this.recordList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            HistoryRecord rec = (HistoryRecord)this.recordList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rec.getDate();
                }
                case 1: {
                    return FileUtils.joinPath((String[])rec.getDirPath());
                }
                case 2: {
                    return rec.getUserLogin();
                }
                case 3: {
                    return rec.getUserName();
                }
                case 4: {
                    return rec.getDescription();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            return this.columnClasses[columnIndex];
        }
    }
}

