/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import csbase.client.applicationmanager.ApplicationCache;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.desktop.DesktopFrame;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public final class ClearApplicationCacheAction
extends AbstractAction {
    @Override
    public void actionPerformed(ActionEvent ae) {
        if (!this.isEnabled()) {
            String err = "Action perform called and it is inactive!";
            throw new RuntimeException("Action perform called and it is inactive!");
        }
        ApplicationManager appManager = ApplicationManager.getInstance();
        try {
            boolean doClear = true;
            if (appManager.hasRunningApplications()) {
                String title = LNG.get((String)"application.manager.warning.title.clear.cache");
                String question = LNG.get((String)"application.manager.warning.clear.cache");
                DesktopFrame frame = DesktopFrame.getInstance();
                int result = StandardDialogs.showYesNoDialog((Component)frame.getDesktopFrame(), (String)title, (Object)question);
                if (result == 1) {
                    doClear = false;
                }
            }
            if (doClear) {
                ApplicationCache.clearCache();
            }
        }
        catch (ApplicationException e) {
            throw new RuntimeException(e);
        }
    }

    public ClearApplicationCacheAction() {
        String actionName = LNG.get((String)"application.manager.action.clear.cache");
        this.putValue("Name", actionName);
    }
}

