/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.DefineUsersTask;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.usersearch.UserDialog;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;

public class SetProjectSharedAction
extends ProjectsManagerAction {
    public SetProjectSharedAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() throws Exception {
        UserDialog ud;
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() == 0) {
            return;
        }
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        if (projects.size() == 1) {
            ProjectsManagerData pmd = projects.get(0);
            ud = new UserDialog(appFrame, projectsManager.getUsers(), pmd.getUsersRO(), pmd.getUsersRW(), true, true);
        } else {
            ud = new UserDialog((Window)appFrame, projectsManager.getUsers(), true, true);
        }
        String title = this.getString("SetProjectSharedAction.selection.title");
        ud.setTitle(title);
        ud.execute();
        Set<Object> usersRO = ud.getUsersRO();
        Set<Object> usersRW = ud.getUsersRW();
        if (usersRO.isEmpty() && usersRW.isEmpty()) {
            return;
        }
        boolean ret = this.runTask(projects, usersRO, usersRW);
        if (ret) {
            projectsManager.refreshProjectsTable();
            projectsManager.refreshInfoPanel();
        }
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ApplicationImages.ICON_SHARED_16;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        String someDeniedMessage;
        int res;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        User loggedUser = User.getLoggedUser();
        Object loggedUserId = loggedUser.getId();
        int i = 0;
        while (i < prjList.size()) {
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
            boolean isAdmin = loggedUser.isAdmin();
            boolean isOwner = pmd.getOwnerId().equals(loggedUserId);
            if (spaceAllocation.isOpenable() && (isAdmin || isOwner)) {
                ++i;
                continue;
            }
            failedProjects.add(pmd);
            prjList.remove(i);
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = this.getString("SetProjectSharedAction.project.selection.denied.message") + this.getString("SetProjectSharedAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("SetProjectSharedAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 && (res = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = this.getString("SetProjectSharedAction.project.selection.some.denied.message") + this.getString("SetProjectSharedAction.project.requirements.message"), prjList, this.getString("SetProjectSharedAction.project.selection.some.failure.message"))) == 0) {
            return null;
        }
        return prjList;
    }

    private boolean runTask(List<ProjectsManagerData> projects, Set<Object> idsRO, Set<Object> idsRW) throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        DefineUsersTask defineUsersTask = new DefineUsersTask(projectsManager, projects, idsRO, idsRW);
        ApplicationFrame frame = projectsManager.getApplicationFrame();
        defineUsersTask.execute(frame, this.getString("SetProjectSharedAction.title"), this.getString("SetProjectSharedAction.message"));
        if (defineUsersTask.wasCancelled()) {
            String err = this.getString("SetProjectSharedAction.cancelled.message");
            defineUsersTask.showError(err);
            return false;
        }
        if (!defineUsersTask.getStatus()) {
            Exception exception = defineUsersTask.getError();
            throw exception;
        }
        for (ProjectsManagerData pmd : projects) {
            pmd.setSharingType(ProjectPermissions.SharingType.PARTIAL);
            pmd.setUsers(idsRO, idsRW);
        }
        return true;
    }
}

