/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.sgamonitor.actions;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.sgamonitor.SGAMonitor;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.logic.SGASet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import tecgraf.javautils.gui.StandardDialogs;

public class RestartSGAClusterAction
extends AbstractSimpleApplicationAction<SGAMonitor> {
    public RestartSGAClusterAction(SGAMonitor application) {
        super(application, ApplicationImages.ICON_RESET_16);
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        SGAMonitor application = (SGAMonitor)this.getApplication();
        List<SGASet> selectedSGAs = application.getSelectedSGAs();
        if (this.confirmRestart(selectedSGAs)) {
            for (SGASet sga : selectedSGAs) {
                SGAProxy.restartSGA(sga.getName());
            }
        }
    }

    private boolean confirmRestart(List<SGASet> selectedSGAs) {
        int opt;
        Object app = this.getApplication();
        ApplicationFrame frame = ((Application)app).getApplicationFrame();
        Object[] options = new Object[]{((Application)app).getString("button.restart"), ((Application)app).getString("button.cancel")};
        String title = ((Application)app).getString("confirm.view.title");
        String question = ((Application)app).getString("question.restart.all");
        if (selectedSGAs.size() == 1) {
            SGASet sga = selectedSGAs.get(0);
            question = String.format(((Application)app).getString("question.restart.one"), sga.getName());
        }
        return (opt = StandardDialogs.showOptionDialog((Component)frame, (String)title, (Object)question, (Object[])options)) == 0;
    }
}

