package csbase.client.applications.algorithmsmanager.report.implementations;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

import csbase.client.applications.algorithmsmanager.report.core.AbstractRemoteTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.logic.algorithms.AlgorithmConfigurator.ConfiguratorType;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import tecgraf.javautils.core.lng.LNG;

/**
 * Teste para identificar algoritmos sem nenhum binrio ou nem mesmo informao
 * de verso. Ignora o algoritmo que tiver pelo menos uma verso como fluxo pois
 * fluxo no precisa de binrio
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class TestEmptyAlgorithm extends AbstractRemoteTest<AlgorithmInfo> {

  /**
   * Construtor
   * 
   * @param taskWindow Window para a task
   */
  public TestEmptyAlgorithm(Window taskWindow) {
    super(taskWindow, LNG.get("TestEmptyAlgorithm.task.title"), LNG.get(
      "TestEmptyAlgorithm.task.message"));

  }

  /** {@inheritDoc} */
  @Override
  public List<IResultMessage<AlgorithmInfo>> doTest(
    AlgorithmInfo algorithmInfo) {

    List<IResultMessage<AlgorithmInfo>> list = new ArrayList<>();

    if (algorithmInfo.getVersions() == null || algorithmInfo.getVersions()
      .size() == 0) {
      IResultMessage<AlgorithmInfo> message = new ResultMessage<>(algorithmInfo,
        TestStatus.ERROR, LNG.get("TestEmptyAlgorithm.no.version"));
      list.add(message);
      return list;
    }

    for (AlgorithmVersionInfo version : algorithmInfo.getVersions()) {
      if (version != null) {
        if (version.getType() == ConfiguratorType.FLOW) {
          return list;
        }
        if (version.getPlatformsNames() != null && version.getPlatformsNames()
          .size() > 0) {
          for (String platform : version.getPlatformsNames()) {
            if (version.getExecutables(platform) != null && version
              .getExecutables(platform).size() > 0) {
              return list;
            }
          }
        }
      }
    }

    IResultMessage<AlgorithmInfo> message = new ResultMessage<>(algorithmInfo,
      TestStatus.ERROR, LNG.get("TestEmptyAlgorithm.no.binary"));
    list.add(message);

    return list;
  }

  /** {@inheritDoc} */
  @Override
  public String getName() {
    return LNG.get("TestEmptyAlgorithm.name");
  }

  /** {@inheritDoc} */
  @Override
  public String getDescription() {
    return LNG.get("TestEmptyAlgorithm.description");
  }

  /** {@inheritDoc} */
  @Override
  public Class<AlgorithmInfo> getSubjectClass() {
    return AlgorithmInfo.class;
  }

  /** {@inheritDoc} */
  @Override
  public String getSubjectName(AlgorithmInfo subject) {
    return subject.getName();
  }
}
