package csbase.client.applications.algorithmsmanager.versiontree;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ImportReleaseNotesFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * N raiz da sub-rvore de release notes de uma verso de um algortmo.
 */
public final class ReleaseNotesNode extends AbstractVersionTreeNode {

  /**
   * Verso cuja lista de arquivos de documentao  representada por este n.
   */
  private AlgorithmVersionInfo version;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm este n.
   * @param version Verso cuja lista de arquivos de documentao  representada
   *        por este n.
   */
  public ReleaseNotesNode(VersionTree tree, AlgorithmVersionInfo version) {
    super(tree, version.getReleaseNotesDirName());

    this.version = version;

    if (version.getReleaseNotes() != null) {
      add(new ReleaseNotesFileNode(tree, version, version.getReleaseNotes()));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getImageIcon() {
    return ApplicationImages.ICON_FOLDER_16;
  }

  /**
   * Cria um menu pop-up para este n.
   * 
   * @return um menu pop-up para este n.
   */
  @Override
  public JPopupMenu createPopupMenu() {
    JPopupMenu popupMenu = new JPopupMenu();
    popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
      new ImportReleaseNotesFile(getTree(), version))));

    return popupMenu;
  }

}

//public final class ReleaseNotesNode extends AbstractVersionTreeNode implements
//ITransferableTarget {
//
////Verso cuja lista de arquivos de documentao  representada por este n.
//private AlgorithmVersionInfo version;
//
///**
// * Construtor.
// * 
// * @param tree rvore que detm este n.
// * @param version Verso cuja lista de arquivos de documentao  representada
// *        por este n.
// */
//public ReleaseNotesNode(VersionTree tree, AlgorithmVersionInfo version) {
//  super(tree, version.getReleaseNotesDirName());
//
//  this.version = version;
//
//  if (version.getReleaseNotes() != null) {
//    add(new ReleaseNotesFileNode(tree, version, version.getReleaseNotes()));
//  }
//}
//
///**
// * {@inheritDoc}
// */
//@Override
//public ImageIcon getImageIcon() {
//  return ApplicationImages.ICON_FOLDER_16;
//}
//
///**
// * Cria um menu pop-up para este n.
// * 
// * @return um menu pop-up para este n.
// */
//@Override
//public JPopupMenu createPopupMenu() {
//  JPopupMenu popupMenu = new JPopupMenu();
//  popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
//    new ImportReleaseNotesFile(getTree(), version))));
//
//  return popupMenu;
//}
//
///**
// * {@inheritDoc}
// */
//@Override
//public boolean canImport(Object[] data, DataFlavor flavor) {
//  return null != data && 0 < data.length && ReleaseNotesFileNode.DATA_FLAVOR
//    .equals(flavor);
//}
//
///**
// * {@inheritDoc}
// */
//@Override
//public boolean importData(Object[] data) {
//  DataTransferObject dto = (DataTransferObject) data[0];
//  final AlgorithmVersionInfo sourceVersion = dto.getVersion();
//  List<FileInfo> files = new ArrayList<FileInfo>(data.length);
//  for (Object obj : data) {
//    dto = (DataTransferObject) obj;
//    FileInfo file = dto.getFile();
//    files.add(file);
//  }
//
//  IPathFactory sourcePathFactory = new DocumentationPathFactory(
//    sourceVersion);
//  IPathFactory targetPathFactory = new ReleaseNotesPathFactory(version);
//  AlgorithmManagementProxy.copyFiles(sourceVersion, files, sourcePathFactory,
//    version, null, targetPathFactory, false, getWindow());
//
//  return true;
//}
//
//}
