/*
 * $Id: TableListModel.java 146656 2013-11-07 17:13:39Z mjulia $
 */

package csbase.client.applications.fileexchanger.panels.tablepanel;

import java.io.File;

import javax.swing.table.AbstractTableModel;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.FileExchangerUI;
import csbase.client.applications.fileexchanger.logic.BlockSize;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeMode;
import csbase.client.applications.fileexchanger.logic.ExchangeState;
import csbase.client.applications.fileexchanger.logic.ExchangeType;

/**
 * Modelo da tabela principal
 * 
 * @author Tecgraf/PUC-Rio
 */
public class TableListModel extends AbstractTableModel {

  /**
   * Aplicao
   */
  final private FileExchanger fileExchanger;

  /**
   * {@inheritDoc}
   */
  @Override
  final public int getColumnCount() {
    return fileExchanger.getNumShownColumns();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public int getRowCount() {
    return fileExchanger.getExchangeListSize();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public Object getValueAt(final int row, final int column) {
    final Exchange exchange = fileExchanger.getExchangeItem(row);
    if (exchange == null) {
      return null;
    }

    if (column == 0) {
      final ExchangeType type = exchange.getType();
      return type;
    }
    if (column == 1) {
      return exchange;
    }
    else if (column == 2) {
      return exchange;
    }
    else if (column == 3) {
      final double progress = exchange.getProgress();
      final Integer n = (int) Math.round(progress * 100);
      return n;
    }
    else if (column == 4) {
      final File localFile = exchange.getLocalFile();
      final String path = localFile.getPath();
      return path;
    }
    else if (column == 5) {
      return exchange.getRemoteFilePath();
    }
    else if (column == 6) {
      final long remaining = exchange.getRemainingTime();
      return remaining;
    }
    else if (column == 7) {
      final long remaining = exchange.getElapsedTime();
      return remaining;
    }
    else if (column == 8) {
      if (exchange.getState() == ExchangeState.QUEUED) {
        return 0.0;
      }
      final double rate = exchange.getInstantTransferRateMbSec();
      return rate;
    }
    else if (column == 9) {
      if (exchange.getState() == ExchangeState.QUEUED) {
        return 0.0;
      }
      final double rate = exchange.getGlobalTransferRateMbSec();
      return rate;
    }
    else if (column == 10) {
      final long size = exchange.getTotalTransferSize();
      return size;
    }
    else if (column == 11) {
      return exchange.getTransferMode();
    }
    else if (column == 12) {
      return exchange.getBlockSize();
    }
    else {
      return exchange;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public String getColumnName(final int col) {
    final String tag = "TableListModel." + col + ".column";
    return FileExchangerUI.getString(tag);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public Class<?> getColumnClass(final int column) {
    if (column == 0) {
      return ExchangeType.class;
    }
    else if (column == 1) {
      return Exchange.class;
    }
    else if (column == 2) {
      return Exchange.class;
    }
    else if (column == 3) {
      return Integer.class;
    }
    else if (column == 4) {
      return String.class;
    }
    else if (column == 5) {
      return String.class;
    }
    else if (column == 6) {
      return Long.class;
    }
    else if (column == 7) {
      return Long.class;
    }
    else if (column == 8) {
      return Double.class;
    }
    else if (column == 9) {
      return Double.class;
    }
    else if (column == 10) {
      return Long.class;
    }
    else if (column == 11) {
      return ExchangeMode.class;
    }
    else if (column == 12) {
      return BlockSize.class;
    }
    else {
      return Exchange.class;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public boolean isCellEditable(final int row, final int col) {
    return false;
  }

  /**
   * Construtor.
   * 
   * @param fileExchanger aplicao.
   */
  public TableListModel(final FileExchanger fileExchanger) {
    this.fileExchanger = fileExchanger;
  }
}
