package csbase.client.applications.projectsmanager.panels;

import java.util.Date;
import java.util.List;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;

/**
 * Model da tabela que apresenta informaes de projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
class SimpleTableModel implements TableModel {

  /**
   * Esta string  retornada como uma mensagem de erro esperada, gerada durante
   * a construo do modelo da tabela.
   */
  private final static String EMPTY_PRJS = "@zero_projects";

  /**
   * Painel de projetos
   */
  final private TablePanel tablePanel;

  /**
   * {@inheritDoc}
   */
  @Override
  public int getColumnCount() {
    return 10;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValueAt(int row, int col) {
    final List<ProjectsManagerData> projects = tablePanel.getVisibleProjects();
    if (projects == null) {
      return null;
    }

    if (projects.size() == 0) {
      return EMPTY_PRJS;
    }

    if (row >= projects.size() || row == -1) {
      return null;
    }

    final ProjectsManagerData project = projects.get(row);
    if (col == 0) {
      return project.getScope();
    }
    else if (col == 1) {
      return project.getProjectSpaceAllocation();
    }
    else if (col == 2) {
      if (project.getProjectSpaceAllocation() == ProjectSpaceAllocation.WAITING_ALLOCATION) {
        return project.getRequestedSpace();
      }

      return project.getAllocatedSpace();
    }
    else if (col == 3) {
      return project.getProjectName();
    }
    else if (col == 4) {
      return project.getOwnerId();
    }
    else if (col == 5) {
      return project.getOccupiedSpace();
    }
    else if (col == 6) {
      return new Date(project.getCreationDate());
    }
    else if (col == 7) {
      return new Date(project.getModificationDate());
    }
    else if (col == 8) {
      return project.getServerOwnerName();
    }
    else if (col == 9) {
      /*
       * Evita NullPointerException na ordenao da tabela por este campo.
       */
      final String locationServer = project.getLocationInServer();
      if (locationServer == null) {
        return "";
      }
      return locationServer;
    }
    else {
      throw new RuntimeException();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass(int c) {
    final Object v = getValueAt(0, c);

    if (v == null)
      return null;

    return v.getClass();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getRowCount() {
    final List<ProjectsManagerData> visibleProjects =
      tablePanel.getVisibleProjects();
    return visibleProjects.size();
  }

  /**
   * Construtor
   * 
   * @param tablePanel o painel.
   */
  SimpleTableModel(final TablePanel tablePanel) {
    this.tablePanel = tablePanel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void addTableModelListener(TableModelListener l) {
    /*
     * No faz nada.
     */
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName(int columnIndex) {
    return null;

  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isCellEditable(int rowIndex, int columnIndex) {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void removeTableModelListener(TableModelListener l) {
    /*
     * No faz nada.
     */
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setValueAt(Object value, int rowIndex, int columnIndex) {
    /*
     * No faz nada.
     */
  }
}
