/**
 * $Id$
 */

package csbase.client.applications.projectsmanager.panels.filters;

import javax.swing.JLabel;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;

/**
 * Painel que contem os filtros por data de alterao de projeto.
 * 
 * @author jnlopes
 */
public class ProjectModificationDateFilterPanel extends
  AbstractProjectDateFilter {

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public ProjectModificationDateFilterPanel(
    final ProjectsManager projectsManager) {
    super(projectsManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean projectMatchesFilter(final long initialDate,
    final long finalDate, final ProjectsManagerData prj) {
    final long modificationDate = prj.getModificationDate();
    return modificationDate >= initialDate && modificationDate <= finalDate;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JLabel createMainLabel() {
    final String label =
      getString("ProjectModificationDateFilterPanel.modification.date.title");
    return new JLabel(label);
  }

}
