package csbase.client.applications.projectsynchronization;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import csbase.logic.ProjectSynchronizationData;
import csbase.logic.ProjectSynchronizationUnit;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.WizardException;

public class StepSelectionServers extends StepProjectSynchronization {
  private ContainerSelectionServers containerSelectionServers;
  private ApplicationRegistry registry;

  public StepSelectionServers(ApplicationRegistry registry, String remoteServer,
    String remotePort) {
    this.registry = registry;
    containerSelectionServers = new ContainerSelectionServers(registry,
      remoteServer, remotePort);

    final DocumentListener docListener = new DocumentListener() {
      @Override
      public void removeUpdate(DocumentEvent e) {
        StepSelectionServers.this.notifyChanged();
      }

      @Override
      public void insertUpdate(DocumentEvent e) {
        StepSelectionServers.this.notifyChanged();
      }

      @Override
      public void changedUpdate(DocumentEvent e) {
        StepSelectionServers.this.notifyChanged();
      }
    };

    containerSelectionServers.getServerSelectionA().getEServer().getDocument()
      .addDocumentListener(docListener);
    containerSelectionServers.getServerSelectionA().getEPassword().getDocument()
      .addDocumentListener(docListener);
    containerSelectionServers.getServerSelectionA().getEUser().getDocument()
      .addDocumentListener(docListener);
    containerSelectionServers.getServerSelectionA().getEPort().getDocument()
      .addDocumentListener(docListener);
    containerSelectionServers.getServerSelectionB().getEServer().getDocument()
      .addDocumentListener(docListener);
    containerSelectionServers.getServerSelectionB().getEPort().getDocument()
      .addDocumentListener(docListener);
    containerSelectionServers.getServerSelectionB().getEUser().getDocument()
      .addDocumentListener(docListener);
    containerSelectionServers.getServerSelectionB().getEPassword().getDocument()
      .addDocumentListener(docListener);

    final ActionListener actionListener = new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        StepSelectionServers.this.notifyChanged();
      }
    };
    containerSelectionServers.getServerSelectionB().getRdProjectLocal()
      .addActionListener(actionListener);
    containerSelectionServers.getServerSelectionB().getRdProjectRemote()
      .addActionListener(actionListener);
    containerSelectionServers.getServerSelectionA().getRdProjectLocal()
      .addActionListener(actionListener);
    containerSelectionServers.getServerSelectionA().getRdProjectRemote()
      .addActionListener(actionListener);
  }

  private boolean isLocalASelected() {
    return containerSelectionServers.getServerSelectionA().getRdProjectLocal()
      .isSelected();
  }

  private boolean isLocalBSelected() {
    return containerSelectionServers.getServerSelectionB().getRdProjectLocal()
      .isSelected();
  }

  private String getServerA() {
    return containerSelectionServers.getServerSelectionA().getEServer()
      .getText();
  }

  private String getPortA() {
    return containerSelectionServers.getServerSelectionA().getEPort().getText();
  }

  private String getUserA() {
    return containerSelectionServers.getServerSelectionA().getEUser().getText();
  }

  private String getPasswordA() {
    return new String(containerSelectionServers.getServerSelectionA()
      .getEPassword().getPassword());
  }

  private String getServerB() {
    return containerSelectionServers.getServerSelectionB().getEServer()
      .getText();
  }

  private String getPortB() {
    return containerSelectionServers.getServerSelectionB().getEPort().getText();
  }

  private String getUserB() {
    return containerSelectionServers.getServerSelectionB().getEUser().getText();
  }

  private String getPasswordB() {
    return new String(containerSelectionServers.getServerSelectionB()
      .getEPassword().getPassword());
  }

  @Override
  protected void enter(History arg0) throws WizardException {
  }

  @Override
  protected Container getContainer() {
    return containerSelectionServers.getRootPanel();
  }

  @Override
  protected String getInstruction() {
    return registry.getString("instruction.step1");
  }

  @Override
  protected Class getNext(History arg0) {
    return StepSelectionProjects.class;
  }

  @Override
  protected String getTitle() {
    return registry.getString("title.step1");
  }

  @Override
  protected boolean isReady() {
    if (isLocalASelected() == false) {
      if ((getUserA() == null) || (getUserA().length() == 0)
        || (getPasswordA() == null) || (getPasswordA().length() == 0)
        || (getServerA() == null) || (getServerA().length() == 0)
        || (getPortA() == null) || (getPortA().length() == 0)) {
        return false;
      }
    }
    if (isLocalBSelected() == false) {
      if ((getUserB() == null) || (getUserB().length() == 0)
        || (getPasswordB() == null) || (getPasswordB().length() == 0)
        || (getServerB() == null) || (getServerB().length() == 0)
        || (getPortB() == null) || (getPortB().length() == 0)) {
        return false;
      }
    }
    return true;
  }

  @Override
  protected void exit(History history) {
    ProjectSynchronizationUnit unitA = null;
    ProjectSynchronizationUnit unitB = null;
    if (isLocalASelected()) {
      String login = User.getLoggedUser().getLogin();
      String password = User.getLoggedUser().getPasswordDigest();
      Object id = User.getLoggedUser().getId();
      unitA = new ProjectSynchronizationUnit(null, login, password, id);
      history.addGlobal("serverNameA", "localhost");
    }
    else {
      String login = getUserA();
      String password = getPasswordA();
      String server = getServerA();
      String port = getPortA();
      unitA = new ProjectSynchronizationUnit(server + ":" + port, login,
        password, login);
      history.addGlobal("serverNameA", server);
    }
    if (isLocalBSelected()) {
      String login = User.getLoggedUser().getLogin();
      String password = User.getLoggedUser().getPasswordDigest();
      Object id = User.getLoggedUser().getId();
      unitB = new ProjectSynchronizationUnit(null, login, password, id);
      history.addGlobal("serverNameB", "localhost");
    }
    else {
      String login = getUserB();
      String password = getPasswordB();
      String server = getServerB();
      String port = getPortB();
      unitB = new ProjectSynchronizationUnit(server + ":" + port, login,
        password, login);
      history.addGlobal("serverNameB", server);
    }
    boolean sameProject = false;
    if (isLocalASelected() && isLocalBSelected()) {
      sameProject = true;
    }
    else {
      String serverAIP = hostToIP(getServerA());
      String serverBIP = hostToIP(getServerB());
      if ((isLocalASelected() && serverBIP.equalsIgnoreCase("127.0.0.1"))
        || (isLocalBSelected() && serverAIP.equalsIgnoreCase("127.0.0.1"))
        || (serverAIP.equalsIgnoreCase(serverBIP))) {
        sameProject = true;
      }
    }
    history.addGlobal("data", new ProjectSynchronizationData(unitA, unitB));
    history.addGlobal("sameProjectFlag", new Boolean(sameProject));
    history.addGlobal("indexA", new Integer(-1));
    history.addGlobal("indexB", new Integer(-1));
  }

  /**
   * Obtem o endereo IP de um determinado host
   *
   * @param host
   *
   * @return
   */
  private String hostToIP(String host) {
    String ip = "";
    try {
      InetAddress addr = InetAddress.getByName(host);
      byte[] ipAddr = addr.getAddress();
      for (int i = 0; i < ipAddr.length; i++) {
        if (i > 0) {
          ip += ".";
        }
        ip += (ipAddr[i] & 0xFF);
      }
    }
    catch (UnknownHostException e) {
      ip = "";
    }
    return ip;
  }
}
