package csbase.client.applications.sgamonitor.columns;

import javax.swing.table.TableCellRenderer;

import csbase.client.applications.sgamonitor.columns.util.PercentRenderer;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;

/**
 * Coluna que exibe o consumo de memria RAM de um n de cluster.
 * 
 * @author Tecgraf
 */
public class NodeRAMColumn extends AbstractConfigurableColumn<SGAInfo> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */

  public NodeRAMColumn(String id, Boolean visible,
    IStringProvider stringProvider, Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return Integer.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGAInfo obj) {
    int result = (int) (100.0 - obj.getRAMFreeMemory());
    return (result <= 100) ? result : -1;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return new PercentRenderer();
  }

}
