package csbase.client.applications.sgamonitor.columns;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGASet;

/**
 * Coluna que exibe o nome do servidor de algoritmos, este pode ser um SGA ou um
 * cluster. Se for um SGA, ento essa coluna exibe o seu nome. Caso seja um
 * cluster, essa coluna exibe o nome e o nmero de ns que este cluster possui.
 * 
 * @author Tecgraf
 */
public class ServerColumn extends AbstractConfigurableColumn<SGASet> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */

  public ServerColumn(String id, Boolean visible,
    IStringProvider stringProvider, Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return String.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGASet obj) {
    return obj.getName();
  }

}
