package csbase.client.csdk.v1_0.application;

import java.util.List;

import javax.swing.ImageIcon;

import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.csdk.v1_0.core.CSDKAbstractContext;
import csbase.logic.applicationservice.ApplicationRegistry;
import csdk.v1_0.api.application.IApplication;
import csdk.v1_0.api.application.IApplicationContext;

/**
 * Implementao do contexto de aplicaes do CSDK no ambiente, que permite
 * basicamente o acesso aos dados do registro da aplicao no repositrio de
 * aplicaes do servidor.
 */
public class CSDKApplicationContext extends CSDKAbstractContext implements
  IApplicationContext {

  /**
   * Registro da aplicao no sistema.
   */
  private ApplicationRegistry registry;

  /**
   * Identificador da instncia da aplicao.
   */
  private final String instanceId;

  /**
   * Classe principal da aplicao.
   */
  private Class<? extends IApplication> mainClass;

  /**
   * Construtor.
   * 
   * @param instanceId Identificador da instncia da aplicao.
   * @param mainClass Classe principal da aplicao.
   * @param registry O registro da aplicao no sistema.
   */
  public CSDKApplicationContext(String instanceId,
    Class<? extends IApplication> mainClass, ApplicationRegistry registry) {
    this.instanceId = instanceId;
    this.mainClass = mainClass;
    this.registry = registry;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean hasString(String key) {
    return registry.hasString(key);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getString(String key, Object... objs) {
    if (!isBundleRequired()) {
      String err =
        "Aplicao no est configurada para carregar arquivos de idioma";
      throw new IllegalStateException(err);
    }
    return registry.getString(key, objs);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getApplicationId() {
    return registry.getId();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isPropertyNull(String propName) {
    return registry.isPropertyNull(propName);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isBundleRequired() {
    return registry.isBundleRequired();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getProperty(String propName) {
    return registry.getStringSpecificProperty(propName);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getApplicationName() {
    return registry.getApplicationName(LNG.getLocale());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getImageIcon(String[] path) {
    String imagePath = FileUtils.joinPath('/', path);
    return ApplicationType.getImageIcon(mainClass, imagePath);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getApplicationIcon() {
    byte[] imageDefinition = registry.getImageDefinition();
    if (imageDefinition != null) {
      return new ImageIcon(imageDefinition);
    }
    else {
      return null;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getSmallApplicationIcon() {
    byte[] iconDefinition = registry.getIconDefinition();
    if (iconDefinition != null) {
      return new ImageIcon(iconDefinition);
    }
    else {
      return null;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String[] getApplicationFileTypes() {
    List<String> fileTypes = registry.getFileTypes();
    if (fileTypes == null) {
      return new String[0];
    }
    return fileTypes.toArray(new String[fileTypes.size()]);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getInstanceId() {
    return instanceId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getVersion() {
    return registry.getVersion();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getApplicationDescription() {
    return registry.getApplicationDescription(LNG.getLocale());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getAuthor() {
    return registry.getAuthorName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getAuthorEmail() {
    return registry.getAuthorMail();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isSingleton() {
    return registry.isSingleton();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean requiresProject() {
    return registry.requireProject();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void contextDeactivated() {
    this.registry = null;
    this.mainClass = null;
  }

}
