package csbase.client.facilities.commandtable;

import javax.swing.Icon;

import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;

/**
 * Agrega os dados necessrios para representar o status de um comando nas
 * tabelas de monitorao/visualizao de comandos. Permite a ordenao dos
 * estados.
 * 
 */
public class CommandStatusCellData implements Comparable<CommandStatusCellData> {

  /**
   * cone que representa o status do comando
   */
  protected Icon icon;

  /**
   * Dica que descreve o status do comando
   */
  protected String tooltip;

  /**
   * Informaes bsicas sobre o comando
   */
  protected CommandInfo cmdInfo;

  /**
   * Construtor
   * 
   * @param cmdInfo Informaes bsicas sobre o comando
   * @param icon cone que representa o status do comando
   * @param tooltip Dica que descreve o status do comando
   */
  public CommandStatusCellData(CommandInfo cmdInfo, Icon icon, String tooltip) {
    this.icon = icon;
    this.tooltip = tooltip;
    this.cmdInfo = cmdInfo;
  }

  /**
   * Retorna o cone que representa o status do comando
   * 
   * @return icon
   */
  public Icon getIcon() {
    return icon;
  }

  /**
   * Retorna a dica que descreve o status do comando
   * 
   * @return tooltip
   */
  public String getTooltip() {
    return tooltip;
  }

  /**
   * Retorna os dados bsicos sobre o comando
   * 
   * @return cmdInfo
   */
  public CommandInfo getCmdInfo() {
    return cmdInfo;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object o) {
    if (o != null) {
      if (o instanceof CommandStatusCellData) {
        CommandStatusCellData anotherData = (CommandStatusCellData) o;
        if (this.cmdInfo.equals(anotherData.getCmdInfo())) {
          return true;
        }
      }
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return cmdInfo.getId().hashCode();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int compareTo(CommandStatusCellData anotherCellData) {
    CommandInfo anotherCmdInfo = anotherCellData.getCmdInfo();
    if (anotherCmdInfo == null) {
      return -1;
    }

    CommandStatus status = cmdInfo.getStatus();
    if (status == null) {
      return 1;
    }

    CommandStatus anotherStatus = anotherCmdInfo.getStatus();
    int statusComparison = status.compareTo(anotherStatus);
    if (statusComparison == 0) {
      if (status == CommandStatus.EXECUTING) {
        if (cmdInfo.isQueued() && !anotherCmdInfo.isQueued()) {
          return 1;
        }
        else if (!cmdInfo.isQueued() && anotherCmdInfo.isQueued()) {
          return -1;
        }
        else if (cmdInfo.isValid() && !anotherCmdInfo.isValid()) {
          return 1;
        }
        else if (!cmdInfo.isValid() && anotherCmdInfo.isValid()) {
          return -1;
        }
      }
      if (status == CommandStatus.FINISHED) {
        CommandFinalizationType anotherFinalizationType =
          anotherCmdInfo.getFinalizationType();
        CommandFinalizationType finalizationType =
          cmdInfo.getFinalizationType();
        if (finalizationType != null) {
          return finalizationType.compareTo(anotherFinalizationType);
        }
      }
    }
    return statusComparison;
  }
}
