package csbase.client.preferences.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.util.PreferenceBundle;

/**
 * Preferncia que encapsula uma lista de {@link String}. Este valor deve ser
 * usado da seguinte forma:<br>
 * 
 * \@Value(type=PVList.class, defaultValue="ab, cd, ef")
 * 
 * @see PreferenceValue PreferenceCategory PreferencePolicy
 * 
 * @author Tecgraf
 */
public class PVList extends PreferenceValue<List<String>> {

  /**
   * Construtor usado na instanciao desta classe por reflexo.
   * 
   * @param name nome da preferncia que possui este valor.
   * @param value valor da preferncia.
   * @param defaultValue valor default da preferncia.
   * @param policy poltica de visibilidade do valor.
   * @param preferenceBundle objeto responsvel pela internacionalizao.
   */
  public PVList(PreferenceDefinition name, String value, String defaultValue,
    PreferencePolicy policy, PreferenceBundle preferenceBundle) {
    super(name, value, defaultValue, policy, preferenceBundle);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getClassName() {
    return getClass().getName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    List<String> list = getValue();
    StringBuilder builder = new StringBuilder();
    for (int i = 0; i < list.size(); i++) {
      String v = list.get(i);
      builder.append(v);
      if (i < list.size() - 1) {
        builder.append(",");
      }
    }
    return builder.toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<String> toValue(String value) {
    List<String> result = new ArrayList<String>();

    if (value.isEmpty()) {
      return result;
    }

    String[] array = value.split(" *, *");

    Collections.addAll(result, array);

    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PreferenceValue<List<String>> clone() {
    PVList clone = new PVList(name, this.toString(), defaultValue, policy,
      preferenceBundle);

    clone.setPreferenceEditorClass(this.getPreferenceEditorClass());
    return clone;
  }
}
