/*
 * $Id: BasicProjectTree.java 176427 2016-10-04 14:35:28Z fpina $
 */
package csbase.client.project;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.kernel.ClientException;
import csbase.client.project.action.CommonDirectoryCreationAction;
import csbase.client.project.action.CommonDirectoryRefreshAction;
import csbase.client.project.action.CommonFileChangeStateAction;
import csbase.client.project.action.CommonFileCopyAction;
import csbase.client.project.action.CommonFileCutAction;
import csbase.client.project.action.CommonFileDeleteAction;
import csbase.client.project.action.CommonFileDownloadAction;
import csbase.client.project.action.CommonFileImportAction;
import csbase.client.project.action.CommonFileOpenAction;
import csbase.client.project.action.CommonFilePasteAction;
import csbase.client.project.action.CommonFilePropertiesShowAction;
import csbase.client.project.action.CommonFileRenameAction;
import csbase.client.project.action.CommonFileTypeChangeAction;
import csbase.client.project.action.CommonFileTypeInferAction;
import csbase.client.project.action.CommonFileUpdateAction;
import csbase.client.project.action.CommonMultiSelectionFileTypeChangeAction;
import csbase.client.project.action.DirectorySortExtAction;
import csbase.client.project.action.DirectorySortNameAction;
import csbase.client.project.action.DirectorySortTypeAction;
import csbase.client.project.action.ExportFilesToDirAction;
import csbase.client.project.action.FileUnlockAction;
import csbase.client.project.action.ProjectTreeUpdateAction;
import csbase.client.project.action.SingleFileExportAction;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;
import csbase.logic.ProjectFileType;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import tecgraf.javautils.core.lng.LNG;

/**
 * Esta classe  uma implementao bsica (ou mnima) de uma rvore de projetos,
 * para uso por clientes de sistemas desenvolvidos a partir do CSBASE. Esta
 * implementao deve ser revista!
 *
 * @author Tecgraf/PUC-Rio
 */
public class BasicProjectTree extends ProjectTree {
  /**
   * Item de menu para criao de diretrio
   */
  protected JMenuItem rootCreateDirMenuItem;

  /**
   * Item de menu para ordenao de diretrio
   */
  protected JMenuItem rootSortDirMenuItem;

  /**
   * Item de menu para atualizar diretrio
   */
  protected JMenuItem rootRefreshProjectMenuItem;

  /**
   * Item de menu para cpia
   */
  protected JMenuItem rootCopyFileMenuItem;

  /**
   * Item de menu para colagem
   */
  protected JMenuItem rootPasteFileMenuItem;

  /**
   * Item de menu para importao no diretrio
   */
  protected JMenuItem rootImportMenuItem;

  /**
   * Item de menu para exportao do diretrio
   */
  protected JMenuItem rootExportMenuItem;

  /**
   * Item de menu para visualizao de propriedades do root
   */
  protected JMenuItem rootSeeFilePropertiesMenuItem;

  /**
   * Boto para ordenao da rvore pelo nome
   */
  protected JRadioButtonMenuItem rootSortByNameRadio;

  /**
   * Boto para ordenao da rvore pela extenso
   */
  protected JRadioButtonMenuItem rootSortByExtRadio;

  /**
   * Boto para ordenao da rvore pelo tipo
   */
  protected JRadioButtonMenuItem rootSortByTypeRadio;

  /**
   * Item de menu para criao dataset.
   */
  protected JMenuItem datasetCreateDirMenuItem;

  /**
   * Item de menu para abrir dataset.
   */
  protected JMenuItem datasetOpenMenuItem;

  /**
   * Item de menu para inferir tipo do dataset.
   */
  protected JMenuItem datasetInferFileTypeMenuItem;

  /**
   * Item de menu para ordenao do dataset
   */
  protected JMenuItem datasetSortDirMenuItem;

  /**
   * Item de menu para atualizao do diretrio
   */
  protected JMenuItem datasetRefreshDirMenuItem;

  /**
   * Item de menu para recortar o dataset
   */
  protected JMenuItem datasetCutFileMenuItem;

  /**
   * Item de menu para cpia do dataset
   */
  protected JMenuItem datasetCopyFileMenuItem;

  /**
   * Item de menu para colagem no diretrio
   */
  protected JMenuItem datasetPasteFileMenuItem;

  /**
   * Item de menu para renomear o dataset
   */
  protected JMenuItem datasetRenameFileMenuItem;

  /**
   * Item de menu para apagar o dataset
   */
  protected JMenuItem datasetDeleteFileMenuItem;

  /**
   * Item de menu para alterar o tipo do arquivo de dataset
   */
  protected JMenuItem datasetChangeFileTypeMenuItem;

  /**
   * Item de menu para importao no dataset
   */
  protected JMenuItem datasetImportMenuItem;

  /**
   * Item de menu para exportao do dataset
   */
  protected JMenuItem datasetExportMenuItem;

  /**
   * Boto para ordenao do dataset pelo nome
   */
  protected JRadioButtonMenuItem datasetSortByNameRadio;

  /**
   * Boto para ordenao do dataset pela extenso
   */
  protected JRadioButtonMenuItem datasetSortByExtRadio;

  /**
   * Boto para ordenao do dataset pelo tipo
   */
  protected JRadioButtonMenuItem datasetSortByTypeRadio;

  /**
   * Item de menu para visualizar as propriedades do dataset
   */
  protected JMenuItem datasetSeeFilePropertiesMenuItem;

  /**
   * Submenu para trocar o estado do dataset em construo
   */
  protected JMenuItem datasetChangeStateFileMenuItem;

  /**
   * Submenu para as opes avanadas de dataset.
   */
  protected JMenu datasetAdvancedSubmenu;

  /**
   * Submenu de aes de dataset.
   */
  protected JMenu datasetActionsSubmenu;

  /**
   * Submenu de aes "abrir com.." de dataset.
   */
  protected JMenu datasetOpenWithSubmenu;

  /**
   * Item de menu para criao do diretrio
   */
  protected JMenuItem dirCreateDirMenuItem;

  /**
   * Item de menu para abrir arquivo/diretrio.
   */
  protected JMenuItem dirOpenMenuItem;

  /**
   * Item de menu para selecionar ferramenta para abrir arquivo/diretrio.
   */
  protected JMenu dirOpenWithSubmenu;

  /**
   * Item de menu para inferir tipo do arquivo/diretrio.
   */
  protected JMenuItem dirInferFileTypeMenuItem;

  /**
   * Item de menu para abrir submenu de aes.
   */
  protected JMenu dirActionsSubmenu;

  /**
   * Item de menu para ordenao do diretrio
   */
  protected JMenuItem dirSortDirMenuItem;

  /**
   * Item de menu para atualizao do diretrio
   */
  protected JMenuItem dirRefreshDirMenuItem;

  /**
   * Item de menu para recortar o diretrio
   */
  protected JMenuItem dirCutFileMenuItem;

  /**
   * Item de menu para cpia do diretrio
   */
  protected JMenuItem dirCopyFileMenuItem;

  /**
   * Item de menu para colagem no diretrio
   */
  protected JMenuItem dirPasteFileMenuItem;

  /**
   * Item de menu para renomear o diretrio
   */
  protected JMenuItem dirRenameFileMenuItem;

  /**
   * Item de menu para apagar o diretrio
   */
  protected JMenuItem dirDeleteFileMenuItem;

  /**
   * Item de menu para alterar o tipo do arquivo
   */
  protected JMenuItem dirChangeFileTypeMenuItem;

  /**
   * Item de menu para importao no diretrio
   */
  protected JMenuItem dirImportMenuItem;

  /**
   * Item de menu para exportao do diretrio
   */
  protected JMenuItem dirExportMenuItem;

  /**
   * Boto para ordenao do diretrio pelo nome
   */
  protected JRadioButtonMenuItem dirSortByNameRadio;

  /**
   * Boto para ordenao do diretrio pela extenso
   */
  protected JRadioButtonMenuItem dirSortByExtRadio;

  /**
   * Boto para ordenao do diretrio pelo tipo
   */
  protected JRadioButtonMenuItem dirSortByTypeRadio;

  /**
   * Item de menu para visualizar as propriedades do diretrio
   */
  protected JMenuItem dirSeeFilePropertiesMenuItem;

  /**
   * Submenu para trocar o estado do diretrio em construo
   */
  protected JMenuItem dirChangeStateFileMenuItem;

  /**
   * Submenu para as opes avanado
   */
  protected JMenu dirAdvancedSubmenu;

  /**
   * Item de menu para abrir arquivo com a aplicao associada
   */
  protected JMenuItem fileOpenMenuItem;

  /**
   * Item de menu para abrir arquivo com o bloco de notas
   */
  protected JMenuItem notepadFileOpenMenuItem;

  /**
   * Item de menu para visualizar as propriedades do arquivo
   */
  protected JMenuItem fileSeeFilePropertiesMenuItem;

  /**
   * Item de menu para recortar o arquivo
   */
  protected JMenuItem fileCutFileMenuItem;

  /**
   * Item de menu para copiar o arquivo
   */
  protected JMenuItem fileCopyFileMenuItem;

  /**
   * Item de menu para renomear o arquivo
   */
  protected JMenuItem fileRenameFileMenuItem;

  /**
   * Item de menu para alterar o tipo do arquivo
   */
  protected JMenuItem fileChangeFileTypeMenuItem;

  /**
   * Item de menu para alterar o tipo do arquivo
   */
  protected JMenuItem fileInferFileTypeMenuItem;

  /**
   * Item de menu para apagar o arquivo
   */
  protected JMenuItem fileDeleteFileMenuItem;

  /**
   * Item de menu para visualizar o arquivo com o navegador
   */
  protected JMenuItem fileDownloadFileMenuItem;

  /**
   * Item de menu para exportar o arquivo
   */
  protected JMenuItem fileExportFileMenuItem;

  /**
   * Item de menu para atualizar um arquivo
   */
  protected JMenuItem fileUpdateFileMenuItem;

  /**
   * Submenu para as opes avanado
   */
  protected JMenu fileAdvancedSubmenu;

  /**
   * Submenu de aes que dependem dos arquivos selecionados
   */
  protected JMenu msActionsSubmenu;

  /**
   * Submenu de aes que dependem do arquivo selecionado
   */
  protected JMenu fileActionsSubmenu;

  /**
   * Submenu de aes que dependem do arquivo selecionado
   */
  protected JMenu fileOpenWithSubmenu;

  /**
   * Submenu para trocar o estado dos arquivo em construo
   */
  protected JMenuItem fileChangeStateFileMenuItem;

  /**
   * Submenu para desbloquear arquivo.
   */
  protected JMenuItem fileUnlockFileMenuItem;

  /**
   * Item de menu para cpia com seleo mltipla
   */
  protected JMenuItem msCutFileMenuItem;

  /**
   * Item de menu para recortar com seleo mltipla
   */
  protected JMenuItem msCopyFileMenuItem;

  /**
   * Item de menu para apagar com seleo mltipla
   */
  protected JMenuItem msDeleteFileMenuItem;

  /**
   * Item de menu para trocar o tipo dos arquivos com seleo mltipla
   */
  protected JMenuItem fileMultiSelectionChangeFileTypeMenuItem;

  /**
   * Item de menu para exportao com seleo mltipla
   */
  protected JMenuItem msExportFileMenuItem;

  /**
   * Constri uma viso da rvore sem projeto associado.
   *
   * @param owner janela na qual a rvore  exibida
   * @param title ttulo da rvore
   *
   * @throws ClientException em caso de falha.
   */
  public BasicProjectTree(final Window owner, final String title)
    throws ClientException {
    this(owner, title, null, null);
  }

  /**
   * Constri uma viso da rvore de um diretrio de um projeto.
   *
   * @param owner janela na qual a rvore  exibida
   * @param title ttulo da rvore
   * @param project o projeto cuja rvore  apresentada.
   *
   * @throws ClientException em caso de falha.
   */
  public BasicProjectTree(final Window owner, final String title,
    final CommonClientProject project) throws ClientException {
    this(owner, title, project, null);
  }

  /**
   * Constri uma viso da rvore de um diretrio de um projeto, usando um
   * filtro para montar a rvore.
   *
   * @param owner janela na qual a rvore  exibida
   * @param title ttulo da rvore
   * @param project o projeto cuja rvore  apresentada.
   * @param visualFilter filtro a ser utilizado para a construo da rvore.
   *
   * @throws ClientException em caso de falha.
   */
  public BasicProjectTree(final Window owner, final String title,
    final CommonClientProject project, final ProjectFileFilter visualFilter)
    throws ClientException {
    this(owner, title, project, visualFilter, null);
  }

  /**
   * Constri uma viso da rvore de um diretrio de um projeto, usando filtros
   * para montar a rvore e para a seleo de arquivos.
   *
   * @param owner janela na qual a rvore  exibida
   * @param title ttulo da rvore
   * @param project o projeto cuja rvore  apresentada.
   * @param visualFilter filtro de visualizao
   * @param selectionFilter filtero de seleo
   *
   * @throws ClientException em caso de falha.
   */
  public BasicProjectTree(final Window owner, final String title,
    final CommonClientProject project, final ProjectFileFilter visualFilter,
    final ProjectFileFilter selectionFilter) throws ClientException {
    super(owner, title, project, visualFilter, selectionFilter);

    try {
      ClientProjectFileType.loadFileTypes(LNG.getLocale());
    }
    catch (final Exception e) {
      throw new ClientException(LNG.get("desktop.file_types_error"), e);
    }
    addProjectTreeListener(new ProjectTreeAdapter() {
      @Override
      public void popupFileTriggered(final ClientProjectFile file) {
        configureFileMenu(file);
      }

      @Override
      public void popupDirTriggered(final ClientProjectFile dir) {
        configureDirMenu(dir);
      }

      @Override
      public void popupDatasetTriggered(final ClientProjectFile dir) {
        configureDatasetMenu(dir);
      }

      @Override
      public void popupMultSelectionTriggered() {
        configureMultipleSelectionMenu();
      }

      @Override
      public void popupRootTriggered() {
        configureRootMenu();
      }
    });
    setPopupRoot(createPopupRoot());
    setPopupDir(createPopupDir());
    setPopupDataset(createPopupDataset());

    /*
     * Os menus do diretrio raiz e dos subdiretrios, que selecionam a
     * ordenao da rvore, precisam * ficar consistentes, pois a ordenao 
     * sempre * feita na rvore como um todo.
     */
    dirSortByNameRadio.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent ev) {
        rootSortByNameRadio.setSelected(true);
      }
    });
    dirSortByExtRadio.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent ev) {
        rootSortByExtRadio.setSelected(true);
      }
    });
    dirSortByTypeRadio.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent ev) {
        rootSortByTypeRadio.setSelected(true);
      }
    });

    rootSortByNameRadio.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent ev) {
        dirSortByNameRadio.setSelected(true);
      }
    });
    rootSortByExtRadio.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent ev) {
        dirSortByExtRadio.setSelected(true);
      }
    });
    rootSortByTypeRadio.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent ev) {
        dirSortByTypeRadio.setSelected(true);
      }
    });

    setPopupFile(createPopupFile());
    setPopupMultSelection(createPopupMultSelection());
    setSingleSelectionMode(false);

  }

  /**
   * Cria o menu para ordenao de um diretrio do projeto.
   *
   * @param nameRadio radioButton para ordenao por nome
   * @param extRadio radioButton para ordernao por extenso
   * @param typeRadio radioButton para ordernao por extenso
   *
   * @return o menu de ordenao
   */
  protected JMenuItem createSortDirMenuItem(
    final JRadioButtonMenuItem nameRadio, final JRadioButtonMenuItem extRadio,
    final JRadioButtonMenuItem typeRadio) {
    final JMenuItem sortDirMenuItem = new JMenu(LNG.get("PRJ_SORT_DIR"));
    final ButtonGroup sortGroup = new ButtonGroup();
    sortGroup.add(nameRadio);
    sortGroup.add(extRadio);
    sortGroup.add(typeRadio);
    nameRadio.setSelected(true);
    sortDirMenuItem.add(nameRadio);
    sortDirMenuItem.add(extRadio);
    sortDirMenuItem.add(typeRadio);
    return sortDirMenuItem;
  }

  /**
   * Cria o menu popup de um diretrio raiz de projeto.
   *
   * @return o menu popup do diretrio raiz
   *
   * @see #createPopupRootMenuItems()
   */
  protected ProjectTreePopupMenu createPopupRoot() {
    /* Cria os tens de menu */
    List<JComponent> items = createPopupRootMenuItems();

    /* Cria o menu a partir da ordem fornecida */
    final ProjectTreePopupMenu menu = new ProjectTreePopupMenu();
    for (JComponent item : items) {
      menu.add(item);
    }

    return menu;
  }

  /**
   * Cria os itens de menu popup de um diretrio raiz de projeto.
   *
   * @return itens de menu popup do diretrio raiz
   */
  protected List<JComponent> createPopupRootMenuItems() {
    rootCreateDirMenuItem =
      new JMenuItem(new CommonDirectoryCreationAction(this));
    rootSortByNameRadio =
      new JRadioButtonMenuItem(new DirectorySortNameAction(this));
    rootSortByExtRadio =
      new JRadioButtonMenuItem(new DirectorySortExtAction(this));
    rootSortByTypeRadio =
      new JRadioButtonMenuItem(new DirectorySortTypeAction(this));
    rootSortDirMenuItem = createSortDirMenuItem(rootSortByNameRadio,
      rootSortByExtRadio, rootSortByTypeRadio);
    rootRefreshProjectMenuItem =
      new JMenuItem(new ProjectTreeUpdateAction(this));
    rootCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
    rootPasteFileMenuItem = new JMenuItem(new CommonFilePasteAction(this));
    rootImportMenuItem = new JMenuItem(new CommonFileImportAction(this));
    rootExportMenuItem = new JMenuItem(new ExportFilesToDirAction(this));
    rootSeeFilePropertiesMenuItem =
      new JMenuItem(new CommonFilePropertiesShowAction(this));

    /* Cria a lista padro para o menu */
    List<JComponent> list = new ArrayList<>();
    list.add(rootCreateDirMenuItem);
    list.add(rootSortDirMenuItem);
    list.add(rootRefreshProjectMenuItem);
    list.add(new JSeparator());
    list.add(rootCopyFileMenuItem);
    list.add(rootPasteFileMenuItem);
    list.add(new JSeparator());
    list.add(rootImportMenuItem);
    list.add(rootExportMenuItem);
    list.add(new JSeparator());
    list.add(rootSeeFilePropertiesMenuItem);
    return list;
  }

  /**
   * Cria o menu popup de um diretrio de projeto.
   *
   * @return o menu popup de um diretrio
   *
   * @see #createPopupDirMenuItems()
   */
  protected ProjectTreePopupMenu createPopupDir() {
    /* Cria os tens de menu */
    List<JComponent> items = createPopupDirMenuItems();

    /* Cria o menu a partir da ordem fornecida */
    final ProjectTreePopupMenu menu = new ProjectTreePopupMenu();
    for (JComponent item : items) {
      menu.add(item);
    }

    return menu;
  }

  /**
   * Cria os itens de menu popup de um diretrio de projeto.
   *
   * @return itens de menu popup de um diretrio
   */
  protected List<JComponent> createPopupDirMenuItems() {
    dirCreateDirMenuItem =
      new JMenuItem(new CommonDirectoryCreationAction(this));
    dirOpenMenuItem = new JMenuItem(new CommonFileOpenAction(this));

    dirSortByNameRadio =
      new JRadioButtonMenuItem(new DirectorySortNameAction(this));

    dirSortByExtRadio =
      new JRadioButtonMenuItem(new DirectorySortExtAction(this));

    dirSortByTypeRadio =
      new JRadioButtonMenuItem(new DirectorySortTypeAction(this));

    dirSortDirMenuItem = createSortDirMenuItem(dirSortByNameRadio,
      dirSortByExtRadio, dirSortByTypeRadio);

    dirRefreshDirMenuItem =
      new JMenuItem(new CommonDirectoryRefreshAction(this));
    dirSeeFilePropertiesMenuItem =
      new JMenuItem(new CommonFilePropertiesShowAction(this));
    dirCutFileMenuItem = new JMenuItem(new CommonFileCutAction(this));
    dirCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
    dirPasteFileMenuItem = new JMenuItem(new CommonFilePasteAction(this));
    dirRenameFileMenuItem = new JMenuItem(new CommonFileRenameAction(this));
    dirChangeFileTypeMenuItem =
      new JMenuItem(new CommonFileTypeChangeAction(this));
    dirInferFileTypeMenuItem =
      new JMenuItem(new CommonFileTypeInferAction(this));
    dirDeleteFileMenuItem = new JMenuItem(new CommonFileDeleteAction(this));
    dirImportMenuItem = new JMenuItem(new CommonFileImportAction(this));
    dirExportMenuItem = new JMenuItem(new ExportFilesToDirAction(this));

    /* Submenu aes */
    final String acTitle = LNG.get("BasicProjectTree.popupmenu.file.actions");
    dirActionsSubmenu = new JMenu(acTitle);

    dirChangeStateFileMenuItem =
      new JMenuItem(new CommonFileChangeStateAction(this));
    dirAdvancedSubmenu =
      new JMenu(LNG.get("BasicProjectTree.popupmenu.advanced"));
    dirAdvancedSubmenu.add(dirChangeStateFileMenuItem);

    /* Cria a lista padro para o menu */
    List<JComponent> list = new ArrayList<>();
    list.add(dirCreateDirMenuItem);
    list.add(new JSeparator());
    list.add(dirOpenMenuItem);
    list.add(dirActionsSubmenu);
    list.add(new JSeparator());
    list.add(dirSortDirMenuItem);
    list.add(dirRefreshDirMenuItem);
    list.add(new JSeparator());
    list.add(dirSeeFilePropertiesMenuItem);
    list.add(new JSeparator());
    list.add(dirCutFileMenuItem);
    list.add(dirCopyFileMenuItem);
    list.add(dirPasteFileMenuItem);
    list.add(new JSeparator());
    list.add(dirRenameFileMenuItem);
    list.add(dirChangeFileTypeMenuItem);
    list.add(dirInferFileTypeMenuItem);
    list.add(dirDeleteFileMenuItem);
    list.add(new JSeparator());
    list.add(dirImportMenuItem);
    list.add(dirExportMenuItem);
    list.add(dirAdvancedSubmenu);
    return list;
  }

  /**
   * Cria o menu popup de um dataset de projeto.
   *
   * @return o menu popup de um dataset
   *
   * @see #createPopupDatasetMenuItems()
   */
  protected ProjectTreePopupMenu createPopupDataset() {
    /* Cria os tens de menu */
    List<JComponent> items = createPopupDatasetMenuItems();

    /* Cria o menu a partir da ordem fornecida */
    final ProjectTreePopupMenu menu = new ProjectTreePopupMenu();
    for (JComponent item : items) {
      menu.add(item);
    }

    return menu;
  }

  /**
   * Cria os itens de menu popup de um diretrio de projeto.
   *
   * @return itens de menu popup de um diretrio
   */
  protected List<JComponent> createPopupDatasetMenuItems() {
    datasetCreateDirMenuItem =
      new JMenuItem(new CommonDirectoryCreationAction(this));
    datasetOpenMenuItem = new JMenuItem(new CommonFileOpenAction(this));

    datasetSortByNameRadio =
      new JRadioButtonMenuItem(new DirectorySortNameAction(this));

    datasetSortByExtRadio =
      new JRadioButtonMenuItem(new DirectorySortExtAction(this));

    datasetSortByTypeRadio =
      new JRadioButtonMenuItem(new DirectorySortTypeAction(this));

    datasetSortDirMenuItem = createSortDirMenuItem(datasetSortByNameRadio,
      datasetSortByExtRadio, datasetSortByTypeRadio);

    datasetRefreshDirMenuItem =
      new JMenuItem(new CommonDirectoryRefreshAction(this));
    datasetSeeFilePropertiesMenuItem =
      new JMenuItem(new CommonFilePropertiesShowAction(this));
    datasetCutFileMenuItem = new JMenuItem(new CommonFileCutAction(this));
    datasetCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
    datasetPasteFileMenuItem = new JMenuItem(new CommonFilePasteAction(this));
    datasetRenameFileMenuItem = new JMenuItem(new CommonFileRenameAction(this));
    datasetChangeFileTypeMenuItem =
      new JMenuItem(new CommonFileTypeChangeAction(this));
    datasetInferFileTypeMenuItem =
      new JMenuItem(new CommonFileTypeInferAction(this));
    datasetDeleteFileMenuItem = new JMenuItem(new CommonFileDeleteAction(this));
    datasetImportMenuItem = new JMenuItem(new CommonFileImportAction(this));
    datasetExportMenuItem = new JMenuItem(new ExportFilesToDirAction(this));

    /* Submenu aes */
    final String acTitle = LNG.get("BasicProjectTree.popupmenu.file.actions");
    datasetActionsSubmenu = new JMenu(acTitle);

    datasetChangeStateFileMenuItem =
      new JMenuItem(new CommonFileChangeStateAction(this));
    datasetAdvancedSubmenu =
      new JMenu(LNG.get("BasicProjectTree.popupmenu.advanced"));
    datasetAdvancedSubmenu.add(datasetChangeStateFileMenuItem);

    /* Cria a lista padro para o menu */
    List<JComponent> list = new ArrayList<>();
    list.add(datasetCreateDirMenuItem);
    list.add(new JSeparator());
    list.add(datasetOpenMenuItem);
    list.add(datasetActionsSubmenu);
    list.add(new JSeparator());
    list.add(datasetSortDirMenuItem);
    list.add(datasetRefreshDirMenuItem);
    list.add(new JSeparator());
    list.add(datasetSeeFilePropertiesMenuItem);
    list.add(new JSeparator());
    list.add(datasetCutFileMenuItem);
    list.add(datasetCopyFileMenuItem);
    list.add(datasetPasteFileMenuItem);
    list.add(new JSeparator());
    list.add(datasetRenameFileMenuItem);
    list.add(datasetChangeFileTypeMenuItem);
    list.add(datasetInferFileTypeMenuItem);
    list.add(datasetDeleteFileMenuItem);
    list.add(new JSeparator());
    list.add(datasetImportMenuItem);
    list.add(datasetExportMenuItem);
    list.add(datasetAdvancedSubmenu);
    return list;
  }

  /**
   * Cria o menu popup de um arquivo do projeto.
   *
   * @return o menu popup do arquivo
   *
   * @see #createPopupFileMenuItems()
   */
  protected ProjectTreePopupMenu createPopupFile() {

    /* Cria os itens de menu */
    List<JComponent> items = createPopupFileMenuItems();

    /* Cria o menu a partir da ordem fornecida */
    final ProjectTreePopupMenu menu = new ProjectTreePopupMenu();
    for (JComponent item : items) {
      menu.add(item);
    }

    return menu;
  }

  /**
   * Cria os itens de menu popup de um arquivo do projeto. Retorna uma lista de
   * componentes que sero associados ao menu.
   *
   * @return lista padro de itens de menu e/ou separadores que ser associada
   *         ao menu.
   */
  protected List<JComponent> createPopupFileMenuItems() {

    fileOpenMenuItem = new JMenuItem(new CommonFileOpenAction(this));

    final String fileOpenWithTitle =
      LNG.get("BasicProjectTree.popupmenu.file.open.with");
    fileOpenWithSubmenu = new JMenu(fileOpenWithTitle);

    final String ntpTitle = LNG.get("BasicProjectTree.open.notepad");
    final String ntpId = "notepad";
    final CommonFileOpenAction ntpAction =
      new CommonFileOpenAction(this, ntpId, ntpTitle);
    notepadFileOpenMenuItem = new JMenuItem(ntpAction);

    final CommonFilePropertiesShowAction propAction =
      new CommonFilePropertiesShowAction(this);
    fileSeeFilePropertiesMenuItem = new JMenuItem(propAction);

    fileUpdateFileMenuItem = new JMenuItem(new CommonFileUpdateAction(this));
    fileCutFileMenuItem = new JMenuItem(new CommonFileCutAction(this));
    fileCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
    fileRenameFileMenuItem = new JMenuItem(new CommonFileRenameAction(this));
    fileChangeFileTypeMenuItem =
      new JMenuItem(new CommonFileTypeChangeAction(this));
    fileInferFileTypeMenuItem =
      new JMenuItem(new CommonFileTypeInferAction(this));

    fileDeleteFileMenuItem = new JMenuItem(new CommonFileDeleteAction(this));
    fileDownloadFileMenuItem =
      new JMenuItem(new CommonFileDownloadAction(this));
    fileExportFileMenuItem = new JMenuItem(new SingleFileExportAction(this));

    /* Submenu avanado */
    fileChangeStateFileMenuItem =
      new JMenuItem(new CommonFileChangeStateAction(this));
    fileUnlockFileMenuItem = new JMenuItem(new FileUnlockAction(this));

    fileAdvancedSubmenu =
      new JMenu(LNG.get("BasicProjectTree.popupmenu.advanced"));
    fileAdvancedSubmenu.add(fileChangeStateFileMenuItem);
    fileAdvancedSubmenu.add(fileUnlockFileMenuItem);

    /* Submenu aes */
    final String acTitle = LNG.get("BasicProjectTree.popupmenu.file.actions");
    fileActionsSubmenu = new JMenu(acTitle);

    /* Cria a lista padro para o menu */
    List<JComponent> list = new ArrayList<JComponent>();
    list.add(fileOpenMenuItem);
    list.add(notepadFileOpenMenuItem);
    list.add(fileActionsSubmenu);
    list.add(new JSeparator());
    list.add(fileSeeFilePropertiesMenuItem);
    list.add(new JSeparator());
    list.add(fileCutFileMenuItem);
    list.add(fileCopyFileMenuItem);
    list.add(new JSeparator());
    list.add(fileRenameFileMenuItem);
    list.add(fileChangeFileTypeMenuItem);
    list.add(fileInferFileTypeMenuItem);
    list.add(fileDeleteFileMenuItem);
    list.add(new JSeparator());
    list.add(fileDownloadFileMenuItem);
    list.add(fileExportFileMenuItem);
    list.add(new JSeparator());
    list.add(fileAdvancedSubmenu);

    return list;
  }

  /**
   * Ajusta o menu do tipo "Abrir com..." para ativao de todas as aplicaes
   * habilitadas a receber o arquivo.
   *
   * @param menuItem item de menu a ser ajustado.
   * @param fileType tipo do arquivo.
   * @param file o arquivo.
   * @return indicativo de aplicaes existentes.
   */
  protected boolean configureOpenWithActionsSubMenu(final JMenuItem menuItem,
    final String fileType, final ClientProjectFile file) {
    final ApplicationManager appManager = ApplicationManager.getInstance();
    final List<String> appIds = appManager.getApplicationsFromType(fileType);
    if (appIds == null) {
      return false;
    }
    final List<JMenuItem> itens = new ArrayList<>();
    for (final String aid : appIds) {
      final ApplicationRegistry reg = appManager.getApplicationRegistry(aid);
      final Locale locale = appManager.getLocale();
      final String name = reg.getApplicationName(locale);
      final CommonFileOpenAction ac = new CommonFileOpenAction(this, aid, name);
      final JMenuItem item = new JMenuItem(ac);
      item.setIcon(appManager.getApplicationIcon(aid));
      itens.add(item);
    }
    Collections.sort(itens, new Comparator<JMenuItem>() {
      @Override
      public int compare(final JMenuItem o1, final JMenuItem o2) {
        final String t1 = o1.getText();
        final String t2 = o2.getText();
        return t1.compareTo(t2);
      }
    });

    for (final JMenuItem item : itens) {
      menuItem.add(item);
    }

    return appIds.size() > 1;
  }

  /**
   * Cria o menu popup para uma seleo mltipla de diretrios/arquivos.
   *
   * @return menu popup para uma seleo mltipla
   *
   * @see #createPopupMultSelectionMenuItems()
   */
  protected ProjectTreePopupMenu createPopupMultSelection() {
    /* Cria os tens de menu */
    List<JComponent> items = createPopupMultSelectionMenuItems();

    /* Cria o menu a partir da ordem fornecida */
    final ProjectTreePopupMenu menu = new ProjectTreePopupMenu();
    for (JComponent item : items) {
      menu.add(item);
    }
    return menu;
  }

  /**
   * Cria os itens de menu popup para uma seleo mltipla de
   * diretrios/arquivos.
   *
   * @return itens de menu popup para uma seleo mltipla
   */
  protected List<JComponent> createPopupMultSelectionMenuItems() {
    msCutFileMenuItem = new JMenuItem(new CommonFileCutAction(this));
    msCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
    msDeleteFileMenuItem = new JMenuItem(new CommonFileDeleteAction(this));
    fileMultiSelectionChangeFileTypeMenuItem =
      new JMenuItem(new CommonMultiSelectionFileTypeChangeAction(this));
    msExportFileMenuItem = new JMenuItem(new ExportFilesToDirAction(this));

    msActionsSubmenu =
      new JMenu(LNG.get("BasicProjectTree.popupmenu.multselection.actions"));

    /* Cria a lista padro para o menu */
    List<JComponent> list = new ArrayList<JComponent>();
    list.add(msActionsSubmenu);
    list.add(new JSeparator());
    list.add(msCutFileMenuItem);
    list.add(msCopyFileMenuItem);
    list.add(new JSeparator());
    list.add(fileMultiSelectionChangeFileTypeMenuItem);
    list.add(msDeleteFileMenuItem);
    list.add(new JSeparator());
    list.add(msExportFileMenuItem);
    return list;
  }

  /**
   * Configura o menu de popup da raiz do projeto.
   */
  protected void configureRootMenu() {
    final ClientProjectFile selectedFile = getSelectedFile();
    final boolean rootSelected =
      (selectedFile != null && selectedFile.getParent() == null);
    rootCreateDirMenuItem.setEnabled(rootSelected);
    rootSortDirMenuItem.setEnabled(true);
    rootRefreshProjectMenuItem.setEnabled(refreshEnabled);
    rootCopyFileMenuItem.setEnabled(rootSelected && transferEnabled);
    if (rootSelected && transferEnabled && hasFileToPaste()) {
      rootPasteFileMenuItem.setEnabled(true);
    }
    else {
      rootPasteFileMenuItem.setEnabled(false);
    }
    rootImportMenuItem.setEnabled(rootSelected);
  }

  /**
   * Configura o menu de popup de um diretrio.
   *
   * @param dir o diretrio selecionado
   */
  protected void configureDirMenu(final ClientProjectFile dir) {
    final boolean dirSelected = (getSelectedFile() == dir);
    boolean isUnderConstruction = dir.isUnderConstruction();
    boolean isInferable = dir.getType().equals(ProjectFileType.DIRECTORY_TYPE);

    dirCreateDirMenuItem.setEnabled(dirSelected);
    dirOpenMenuItem.setEnabled(dirSelected);
    dirSortDirMenuItem.setEnabled(true);
    dirRefreshDirMenuItem.setEnabled(refreshEnabled);
    dirSeeFilePropertiesMenuItem.setEnabled(dirSelected);
    dirCutFileMenuItem
      .setEnabled(dirSelected && !isUnderConstruction && transferEnabled);
    dirCopyFileMenuItem
      .setEnabled(dirSelected && !isUnderConstruction && transferEnabled);
    if (dirSelected && transferEnabled && hasFileToPaste()) {
      dirPasteFileMenuItem.setEnabled(true);
    }
    else {
      dirPasteFileMenuItem.setEnabled(false);
    }
    dirRenameFileMenuItem
      .setEnabled(dirSelected && !isUnderConstruction && renameEnabled);
    dirChangeFileTypeMenuItem.setEnabled(dirSelected && !isUnderConstruction);
    dirInferFileTypeMenuItem
      .setEnabled(dirSelected && !isUnderConstruction && isInferable);
    dirDeleteFileMenuItem.setEnabled(dirSelected && deleteEnabled);
    dirImportMenuItem.setEnabled(dirSelected);
    dirChangeStateFileMenuItem.setEnabled(dirSelected && isUnderConstruction);
    if (dirActionsSubmenu != null) {
      dirActionsSubmenu.removeAll();
      dirActionsSubmenu.setEnabled(false);

      final ClientProjectFile selFile = getSelectedFile();
      if (selFile == null) {
        return;
      }
      final String type = dir.getType();
      final boolean enabled =
        configureFileActionsSubMenu(dirActionsSubmenu, type, dir);
      dirActionsSubmenu.setEnabled(enabled);
    }

    if (dirOpenWithSubmenu != null) {
      dirOpenWithSubmenu.removeAll();
      dirOpenWithSubmenu.setEnabled(false);

      final ClientProjectFile selFile = getSelectedFile();
      if (selFile == null) {
        return;
      }
      final String type = dir.getType();
      final boolean enabled =
        configureOpenWithActionsSubMenu(dirOpenWithSubmenu, type, dir);
      dirOpenWithSubmenu.setEnabled(enabled);
    }

    dirAdvancedSubmenu.setEnabled(isUnderConstruction);
  }

  /**
   * Configura o menu de popup de um dataset.
   *
   * @param dataset o dataset selecionado
   */
  protected void configureDatasetMenu(final ClientProjectFile dataset) {
    final boolean dirSelected = (getSelectedFile() == dataset);
    boolean isUnderConstruction = dataset.isUnderConstruction();
    dirOpenMenuItem.setEnabled(dirSelected);
    dirRefreshDirMenuItem.setEnabled(refreshEnabled);
    dirSeeFilePropertiesMenuItem.setEnabled(dirSelected);
    dirCutFileMenuItem
      .setEnabled(dirSelected && !isUnderConstruction && transferEnabled);
    dirCopyFileMenuItem
      .setEnabled(dirSelected && !isUnderConstruction && transferEnabled);
    dirPasteFileMenuItem
      .setEnabled(dirSelected && transferEnabled && hasFileToPaste());
    dirRenameFileMenuItem
      .setEnabled(dirSelected && !isUnderConstruction && renameEnabled);
    dirChangeFileTypeMenuItem.setEnabled(dirSelected && !isUnderConstruction);
    dirInferFileTypeMenuItem.setEnabled(dirSelected && !isUnderConstruction);
    dirDeleteFileMenuItem.setEnabled(dirSelected && deleteEnabled);
    dirChangeStateFileMenuItem.setEnabled(dirSelected && isUnderConstruction);
    if (datasetActionsSubmenu != null) {
      datasetActionsSubmenu.removeAll();
      datasetActionsSubmenu.setEnabled(false);

      final ClientProjectFile selFile = getSelectedFile();
      if (selFile == null) {
        return;
      }
      final String type = dataset.getType();
      final boolean enabled =
        configureFileActionsSubMenu(datasetActionsSubmenu, type, dataset);
      datasetActionsSubmenu.setEnabled(enabled);
    }

    if (datasetOpenWithSubmenu != null) {
      datasetOpenWithSubmenu.removeAll();
      datasetOpenWithSubmenu.setEnabled(false);

      final ClientProjectFile selFile = getSelectedFile();
      if (selFile == null) {
        return;
      }
      final String type = dataset.getType();
      final boolean enabled =
        configureOpenWithActionsSubMenu(datasetOpenWithSubmenu, type, dataset);
      datasetOpenWithSubmenu.setEnabled(enabled);
    }

    datasetAdvancedSubmenu.setEnabled(isUnderConstruction);
  }

  /**
   * Configura o menu de popup de acordo com o arquivo.
   *
   * @param file arquivo selecionado
   */
  protected void configureFileMenu(final ClientProjectFile file) {
    final boolean isUnderConstruction = file.isUnderConstruction();

    final boolean isInferable = file.getType().equals(ProjectFileType.UNKNOWN);

    fileSeeFilePropertiesMenuItem.setEnabled(true);
    fileUpdateFileMenuItem.setEnabled(file.isUpdatable());
    fileDeleteFileMenuItem.setEnabled(deleteEnabled);
    fileCutFileMenuItem.setEnabled(!isUnderConstruction && transferEnabled);
    fileCopyFileMenuItem.setEnabled(!isUnderConstruction && transferEnabled);
    fileRenameFileMenuItem.setEnabled(!isUnderConstruction && renameEnabled);
    fileChangeFileTypeMenuItem.setEnabled(!isUnderConstruction);
    fileInferFileTypeMenuItem.setEnabled(!isUnderConstruction && isInferable);
    fileDownloadFileMenuItem.setEnabled(!isUnderConstruction);
    fileExportFileMenuItem.setEnabled(!isUnderConstruction);
    fileChangeStateFileMenuItem.setEnabled(isUnderConstruction);
    // Hibilita menu "Avanado".
    final boolean enableUnlock = userCanUnlockFile(file);
    fileUnlockFileMenuItem.setEnabled(enableUnlock);
    fileAdvancedSubmenu.setEnabled(isUnderConstruction || enableUnlock);

    if (fileActionsSubmenu != null) {
      fileActionsSubmenu.removeAll();
      fileActionsSubmenu.setEnabled(false);

      final ClientProjectFile selFile = getSelectedFile();
      if (selFile == null) {
        return;
      }
      final String type = file.getType();
      final boolean enabled =
        configureFileActionsSubMenu(fileActionsSubmenu, type, file);
      fileActionsSubmenu.setEnabled(enabled);
    }

    if (fileOpenWithSubmenu != null) {
      fileOpenWithSubmenu.removeAll();
      fileOpenWithSubmenu.setEnabled(false);

      final ClientProjectFile selFile = getSelectedFile();
      if (selFile == null) {
        return;
      }
      final String type = file.getType();
      final boolean enabled =
        configureOpenWithActionsSubMenu(fileOpenWithSubmenu, type, file);
      fileOpenWithSubmenu.setEnabled(enabled);
    }

  }

  /**
   * Verifica se o usurio corrente pode desbloquear o arquivo.
   *
   * @param file arquivo
   * @return <code>true</code> se o usurio pode desbloquear o arquivo
   */
  protected boolean userCanUnlockFile(final ClientProjectFile file) {
    final User user = User.getLoggedUser();
    return file.isLocked()
      && (getProject().getUserId().equals(user.getId()) || (user.isAdmin()));
  }

  /**
   * Ajusta aes padronizadas de acordo com o(s) arquivo(s) selecionados quando
   * todos so do mesmo tipo.
   *
   * @param menu o menu
   * @param type o tipo do arquivo.
   * @param selectedFile o arquivo selecionado.
   * @return se o submenu de aes deve ficar ativo ou no.
   */
  protected boolean configureFileActionsSubMenu(final JMenu menu,
    final String type, final ClientProjectFile selectedFile) {
    return false;
  }

  /**
   * Ajusta aes padronizadas de acordo com o(s) arquivo(s) selecionados quando
   * todos so do mesmo tipo.
   *
   * @param menu o menu
   * @param type o tipo dos arquivos.
   * @param selectedFiles um array dos arquivos selecionados.
   * @return se o submenu de aes deve ficar ativo ou no.
   */
  protected boolean configureMultSelectionActionsSubMenu(final JMenu menu,
    final String type, final ClientProjectFile[] selectedFiles) {
    return false;
  }

  /**
   * Configura o menu de popup para uma seleo mltipla de arquivos/diretrios
   */
  protected void configureMultipleSelectionMenu() {
    final ClientProjectFile[] selectedFiles = getSelectedFiles();
    msCutFileMenuItem
      .setEnabled(!ClientProjectFile.hasFileUnderConstruction(selectedFiles)
        && transferEnabled);
    msCopyFileMenuItem
      .setEnabled(!ClientProjectFile.hasFileUnderConstruction(selectedFiles)
        && transferEnabled);
    msDeleteFileMenuItem.setEnabled(deleteEnabled);

    Boolean isDirectory = null;
    boolean isEnabled = true;
    for (ClientProjectFile file : selectedFiles) {
      if (isDirectory == null) {
        isDirectory = file.isDirectory();
      }
      else if (file.isDirectory() != isDirectory) {
        isEnabled = false;
        break;
      }
    }
    fileMultiSelectionChangeFileTypeMenuItem.setEnabled(isEnabled);

    if (msActionsSubmenu != null) {
      msActionsSubmenu.removeAll();
      msActionsSubmenu.setEnabled(false);
      final ClientProjectFile[] selFiles = getSelectedFiles();
      if (selFiles == null || selFiles.length == 0) {
        return;
      }

      final ClientProjectFile file0 = selFiles[0];
      final String type0 = file0.getType();
      for (final ClientProjectFile f : selFiles) {
        final String type = f.getType();
        if (!type.equals(type0)) {
          return;
        }
      }
      final boolean enabled =
        configureMultSelectionActionsSubMenu(msActionsSubmenu, type0, selFiles);
      msActionsSubmenu.setEnabled(enabled);
    }
  }
}
