package csbase.client.project;

import java.util.EventObject;

import csbase.logic.ClientProjectFile;

/**
 * Representa um evento de mudana no conjunto de itens selecionados de uma
 * {@link csbase.client.project.ProjectTree}.
 *
 * @author Rodrigo Carneiro Henrique (rodrigoh)
 * @version $Revision: 144754 $
 */
public final class ProjectTreeSelectionEvent extends EventObject {
  /** Representa os arquivos que esto atualmente selecionados na rvore. */
  private ClientProjectFile[] selectedFiles;

  /**
   * Cria um evento de mudana na seleo da rvore de projetos.
   *
   * @param source A origem do evento (normalmente ser uma instncia de {@link
   *        ProjectTree}.
   * @param selectedFiles Um array com os arquivos que esto atualmente
   *        selecionados na rvore.
   *
   * @throws IllegalArgumentException Caso o array de arquivos selecionados
   *         seja null.
   */
  public ProjectTreeSelectionEvent(
    Object source, ClientProjectFile[] selectedFiles) {
    super(source);
    if (selectedFiles == null) {
      throw new IllegalArgumentException(
        "O array de arquivos selecionados no pode ser null. Caso no haja "+
        "arquivos selecionados, utilize um array de tamanho 0 (zero).");
    }
    this.selectedFiles = selectedFiles;
  }

  /**
   * Obtm os arquivos que esto atualmente selecionados na rvore.
   *
   * @return Os arquivos selecionados na rvore. Caso no haja nenhum, o array
   *         ter tamanho 0 (zero).
   */
  public ClientProjectFile[] getSelectedFiles() {
    return this.selectedFiles;
  }
}
