/*
 * CommonProjectUpdateAction.java
 * 
 * $Author: oikawa $ $Revision: 150777 $ - $Date: 2008-06-15 15:45:34 -0300
 * (Sun, 15 Jun 2008) $
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectTree;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommonClientProject;

/**
 * Ao que atualiza os dados de um projeto.
 */
public class CommonProjectUpdateAction extends ProjectAction {

  /**
   * Exceuta a ao.
   * 
   * @param e .
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final DesktopFrame desktopFrame = DesktopFrame.getInstance();
    final CommonClientProject project =
      desktopFrame.openProjectUpdateDialog(getWindow(), getCurrentProject());
    try {
      setCurrentProject(project);
    }
    catch (Exception ex) {
      StandardErrorDialogs.showErrorDialog(getWindow(), getTitle(), ex);
    }
  }

  /**
   * Obtm o nome da ao.
   * 
   * @return .
   */
  @Override
  public String getName() {
    return LNG.get("PRJ_UPDATE");
  }

  /**
   * Constri a ao.
   * 
   * @param treeView .
   */
  public CommonProjectUpdateAction(ProjectTree treeView) {
    super(treeView);
  }

}
