package csbase.client.remote;

/**
 * A classe <code>BasicServerMonitor</code>  uma implementao de
 * <code>RemoteMonitor</code> para uso por um cliente de um sistema construdo
 * a partir do CSBASE.  responsvel por estabelecer a conexo com o servidor
 * e manter as referncias para os servios exportados por este servidor.
 * Durante a execuo, esta classe monitora a comunicao com o servidor. Caso
 * seja detecta falha de comunicao,  aguardado o retorno e as referncias
 * remotas so novamente adquiridas. Todos os observadores destinados a
 * servios remotos so colocados atravs desta classe. Dessa forma, ao haver
 * o reestabelecimento da conexo,  possvel recadastr-los de forma
 * centralizada, aqui. De forma anloga, ao trmino da execuo, esta classe
 * tambm se encarrega de remover os observadores colocados no servidor. Esta
 * classe pode ser observada. Caso haja mudana no estado isAlive(), os
 * observadores sero chamados. Este componente  configurvel para cada
 * sistema. A configurao deste componente compreende: - o nome do sistema em
 * questo - o nome do servidor monitorado - a classe que mantm as
 * referncias para os servios remotos (a especializao de
 * <code>ClientRemoteLocator</code> para o sistema)
 */
public class BasicServerMonitor extends ClientRemoteMonitor {
  /**
   * Constri o monitor conforme a configurao de um sistema especfico.
   *
   * @param systemName nome do sistema
   * @param serverName nome do servidor
   * @param locator classe que mantm as referncias para os objetos remotos
   */
  public BasicServerMonitor(
    String systemName, String serverName, Class<?> locator) {
    super(systemName, serverName, locator);
  }
}
