/*
 * PlatformProxy.java $Author: fpina $ $Revision: 176168 $ - $Date: 2008-02-11
 * 18:35:52 -0200 (Mon, 11 Feb 2008) $
 */
package csbase.client.remote.srvproxies;

import java.awt.Window;
import java.util.Vector;

import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.Platform;
import csbase.logic.PlatformInfo;
import tecgraf.javautils.core.lng.LNG;

/**
 * Classe que modela um proxy client/PlatformProvider.
 * 
 * @author Julia
 */
public class PlatformProxy {
  /**
   * Obtem a lista de plataformas cadastradas. TODO - Mudar tipo de retorno para
   * {@code List<Platform>}
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos.
   * @param title titulo da janela da <code>DesktopTask</code> associada.
   * @param message mensagem exibida na janela da <code>DesktopTask</code>
   *        associada.
   * 
   * @return o vetor de plataformas.
   */
  public static Vector<Platform> getAllPlatforms(Window owner, String title,
    String message) {
    RemoteTask<Vector<Platform>> task = new RemoteTask<Vector<Platform>>() {
      @Override
      public void performTask() throws Exception {
        setResult(new Vector<Platform>(Platform.getAllPlatforms()));
      }
    };
    if (task.execute(owner, title, message)) {
      Vector<Platform> platformsVector = task.getResult();
      if ((platformsVector == null) || (platformsVector.size() <= 0)) {
        return new Vector<Platform>();
      }
      return platformsVector;
    }
    return new Vector<Platform>();
  }

  /**
   * Obtm uma plataforma com uma dada identificao.
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos.
   * @param title titulo da janela da <code>DesktopTask</code> associada.
   * @param message mensagem exibida na janela da <code>DesktopTask</code>
   *        associada.
   * @param platformId o identificador da plataforma.
   * 
   * @return a plataforma requisitada.
   */
  public static Platform getPlatform(Window owner, String title, String message,
    final Object platformId) {
    RemoteTask<Platform> task = new RemoteTask<Platform>() {
      @Override
      public void performTask() throws Exception {
        setResult(Platform.getPlatform(platformId));
      }
    };
    task.execute(owner, title, message);
    return task.getResult();
  }

  /**
   * Cria uma plataforma.
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos.
   * @param title titulo da janela da <code>DesktopTask</code> associada.
   * @param message mensagem exibida na janela da <code>DesktopTask</code>
   *        associada.
   * @param info As informaes da nova plataforma.
   * 
   * @return A plataforma criada.
   */
  public static Platform createPlatform(Window owner, String title,
    String message, final PlatformInfo info) {
    RemoteTask<Platform> task = new RemoteTask<Platform>() {
      @Override
      public void performTask() throws Exception {
        setResult(Platform.createPlatform(info));
      }
    };
    if (task.execute(owner, title, message)) {
      Platform platform = task.getResult();
      if (platform == null) {
        StandardErrorDialogs.showErrorDialog(owner, title, LNG.get(
          "IAS_PLATFORM_ALREADY_EXISTS_ERROR"));
      }
      return platform;
    }
    return null;
  }

  /**
   * Modifica uma plataforma.
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos.
   * @param title titulo da janela da <code>DesktopTask</code> associada.
   * @param message mensagem exibida na janela da <code>DesktopTask</code>
   *        associada.
   * @param platformId o identificador da plataforma a ser alterada.
   * @param info As informaes de modificao da plataforma.
   * 
   * @return A plataforma modificada.
   */
  public static Platform modifyPlatform(Window owner, String title,
    String message, final Object platformId, final PlatformInfo info) {
    RemoteTask<Platform> task = new RemoteTask<Platform>() {
      @Override
      public void performTask() throws Exception {
        setResult(Platform.modifyPlatform(platformId, info));
      }
    };
    if (task.execute(owner, title, message)) {
      Platform platform = task.getResult();
      if (platform == null) {
        StandardErrorDialogs.showErrorDialog(owner, title, LNG.get(
          "IAS_PLATFORM_ALREADY_EXISTS_ERROR"));
      }
      return platform;
    }
    return null;
  }

  /**
   * Remove uma plataforma.
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos.
   * @param title titulo da janela da <code>DesktopTask</code> associada.
   * @param message mensagem exibida na janela da <code>DesktopTask</code>
   *        associada.
   * @param platformId o identificador da plataforma a ser removida.
   */
  public static void deletePlatform(Window owner, String title, String message,
    final Object platformId) {
    RemoteTask<Void> task = new RemoteTask<Void>() {
      @Override
      public void performTask() throws Exception {
        Platform.deletePlatform(platformId);
      }
    };
    task.execute(owner, title, message);
  }
}
