/**
 * $Id$
 */
package csbase.client.util;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import csbase.client.applications.projectsmanager.usersearch.UserPanel;
import csbase.logic.UserOutline;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

/**
 * 
 * 
 * @author Tecgraf
 */
public class SharedObjectUserPanel extends UserPanel {

  /**
   * Checkbox que define se todos os usurios tem acesso global ao objeto
   */
  private JCheckBox globalCheck;

  /**
   * Construtor.
   * 
   * @param allUsers - lista com todos os usurios disponveis para
   *        compartilhamento
   * @param showPermissions Boolean que indica que o esquema de permisses deve
   *        ser exibido.
   */
  public SharedObjectUserPanel(List<UserOutline> allUsers,
    boolean showPermissions) {
    super(allUsers, showPermissions);
  }

  /**
   * Construtor.
   * 
   * @param allUsers - lista com todos os usurios disponveis para
   *        compartilhamento
   * @param usersRO Usurios com permisso de leitura.
   * @param usersRW Usurios com permisso de leitura e escrita.
   * @param showPermissions Boolean que indica que o esquema de permisses deve
   *        ser exibido.
   */
  public SharedObjectUserPanel(List<UserOutline> allUsers, Set<Object> usersRO,
    Set<Object> usersRW, boolean showPermissions) {
    super(allUsers, usersRO, usersRW, showPermissions);
  }

  /**
   * Construtor.
   * 
   * @param allUsers - lista com todos os usurios disponveis para
   *        compartilhamento
   * @param usersRO Usurios com permisso de leitura.
   * @param usersRW Usurios com permisso de leitura e escrita.
   * @param showPermissions Boolean que indica que o esquema de permisses deve
   *        ser exibido.
   * @param fixedAccess Indica se os usurios so todos membros ou no-membros
   *        dos projetos.
   */
  public SharedObjectUserPanel(List<UserOutline> allUsers, Set<Object> usersRO,
    Set<Object> usersRW, boolean showPermissions, boolean fixedAccess) {
    super(allUsers, usersRO, usersRW, showPermissions, fixedAccess);
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  protected JPanel createSharedUsersPanel() {
    JPanel wrapperPanel = new JPanel(new GridBagLayout());
    JPanel panel = super.createSharedUsersPanel();
    GBC gbc = new GBC(0, 0).northwest().insets(5, 15, 0, 0);
    globalCheck = new JCheckBox();
    globalCheck.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        sharedUsersTable.enableReadingOnlyForAll(globalCheck.isSelected());
      }
    });
    globalCheck.setText(LNG.get("SharedObjectUserPanel.globalCheck.label"));
    wrapperPanel.add(globalCheck, gbc);
    gbc = new GBC(0, 1).northwest().insets(5, 15, 0, 0).both();
    wrapperPanel.add(panel, gbc);
    return wrapperPanel;
  }

  /**
   * Retorn true se e somente se, o usurio escolheu leitura permitida para
   * todos os usurios
   * 
   * @return true se e somente se, o usurio escolheu leitura permitida para
   *         todos os usurios
   */
  public boolean isGlobal() {
    return globalCheck.isSelected();
  }

  /**
   * Atribui o valor de permisso para todos os usurios apropriadamente
   * 
   * @param isGlobal booleano que indica se todos os usurios tem acesso global
   *        ao objeto.
   */
  public void setGlobal(boolean isGlobal) {
    globalCheck.setSelected(isGlobal);
    if (isGlobal) {
      sharedUsersTable.enableReadingOnlyForAll(isGlobal);
    }
  }
}
