package csbase.client.util;

import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

/**
 * Classe que permite  aplicao compartilhar uma nica instncia de um
 * <code>JFileChooser</code> (padro <i>Singleton</i>). Essa instncia mantm
 * a memria do ltimo diretrio acessado no sistema de arquivos, o(s)
 * arquivo(s) escolhido(s), etc.
 * 
 * @author Tecgraf
 */
public class SingletonFileChooser extends JFileChooser {

  /** Instncia nica desta classe. */
  private static SingletonFileChooser instance;

  /**
   * Retorna a instncia compartilhada, alterando seu diretrio corrente e sua
   * viso do sistema de arquivos.
   * 
   * @param currentDirectory diretrio em que o dilogo dever abrir.
   * @param fsv viso do sistema de arquivos.
   * 
   * @return instncia nica da classe.
   */
  public static SingletonFileChooser getInstance(File currentDirectory,
    FileSystemView fsv) {
    if (instance == null) {
      instance = new SingletonFileChooser();
    }
    instance.setCurrentDirectory(currentDirectory);
    instance.setFileSystemView(fsv);
    return instance;
  }

  /**
   * Retorna a instncia compartilhada, alterando seu diretrio corrente.
   * 
   * @param currentDirectory diretrio em que o dilogo dever abrir.
   * 
   * @return instncia nica da classe.
   */
  public static SingletonFileChooser getInstance(File currentDirectory) {
    if (instance == null) {
      instance = new SingletonFileChooser();
    }
    instance.setCurrentDirectory(currentDirectory);
    return instance;
  }

  /**
   * Retorna a instncia compartilhada, alterando sua viso do sistema de 
   * arquivos.
   * 
   * @param fsv viso do sistema de arquivos.
   * 
   * @return instncia nica da classe.
   */
  public static SingletonFileChooser getInstance(FileSystemView fsv) {
    if (instance == null) {
      instance = new SingletonFileChooser();
    }
    instance.setFileSystemView(fsv);
    return instance;
  }

  /**
   * Retorna a instncia compartilhada, alterando seu diretrio corrente e sua
   * viso do sistema de arquivos.
   * 
   * @param currentDirectoryPath caminho para o diretrio em que o dilogo 
   *        dever abrir.
   * @param fsv viso do sistema de arquivos.
   * 
   * @return instncia nica da classe.
   */
  public static SingletonFileChooser getInstance(String currentDirectoryPath,
    FileSystemView fsv) {
    if (instance == null) {
      instance = new SingletonFileChooser();
    }
    instance.setCurrentDirectory(new File(currentDirectoryPath));
    instance.setFileSystemView(fsv);
    return instance;
  }

  /**
   * Retorna a instncia compartilhada, alterando seu diretrio corrente.
   * 
   * @param currentDirectoryPath caminho para o diretrio em que o dilogo 
   *        dever abrir.
   * 
   * @return instncia nica da classe.
   */
  public static SingletonFileChooser getInstance(String currentDirectoryPath) {
    if (instance == null) {
      instance = new SingletonFileChooser();
    }
    instance.setCurrentDirectory(new File(currentDirectoryPath));
    return instance;
  }

  /**
   * Retorna a instncia compartilhada.
   * 
   * @return instncia nica da classe.
   */
  public static SingletonFileChooser getInstance() {
    if (instance == null) {
      instance = new SingletonFileChooser();
    }
    return instance;
  }

  /**
   * Construtor privado, garantindo a instncia nica para a classe.
   */
  private SingletonFileChooser() {
    super();
  }

}
