package csbase.client.util;

import java.util.LinkedList;
import java.util.List;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import tecgraf.javautils.core.lng.LNG;

public final class ThrowableTabelModel implements TableModel {

  private static final int CLASS_INDEX = 0;

  private static final int METHOD_INDEX = 1;

  private static final int FILE_INDEX = 2;

  private static final int LINE_INDEX = 3;

  private static final int COLUMN_COUNT = 4;

  private final List tableModelListenerList;

  private final Throwable throwable;

  public ThrowableTabelModel(Throwable throwable) {

    this.throwable = throwable;
    this.tableModelListenerList = new LinkedList();
  }

  public int getRowCount() {

    return this.throwable.getStackTrace().length;
  }

  public int getColumnCount() {

    return COLUMN_COUNT;
  }

  public String getColumnName(int columnIndex) {

    switch (columnIndex) {
      case CLASS_INDEX:
        return LNG.get("UTIL_CLASS");

      case METHOD_INDEX:
        return LNG.get("UTIL_METHOD");

      case FILE_INDEX:
        return LNG.get("UTIL_FILE");

      case LINE_INDEX:
        return LNG.get("UTIL_LINE");

      default:
        throw new IllegalArgumentException("columnIndex == " + columnIndex);
    }
  }

  public Class getColumnClass(int columnIndex) {

    return String.class;
  }

  public boolean isCellEditable(int rowIndex, int columnIndex) {

    return false;
  }

  public Object getValueAt(int rowIndex, int columnIndex) {

    StackTraceElement[] stackTrace = this.throwable.getStackTrace();
    if (rowIndex >= stackTrace.length) {
      throw new IllegalArgumentException("rowIndex == " + rowIndex
        + " : rowCount = " + stackTrace.length);
    }
    StackTraceElement stackTraceElement = stackTrace[rowIndex];

    switch (columnIndex) {
      case CLASS_INDEX:
        return stackTraceElement.getClassName();

      case METHOD_INDEX:
        return stackTraceElement.getMethodName();

      case FILE_INDEX:
        return stackTraceElement.getFileName();

      case LINE_INDEX:
        return Integer.toString(stackTraceElement.getLineNumber());

      default:
        throw new IllegalArgumentException("columnIndex == " + columnIndex);
    }
  }

  public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    throw new UnsupportedOperationException();
  }

  public void addTableModelListener(TableModelListener l) {
    this.tableModelListenerList.add(l);

  }

  public void removeTableModelListener(TableModelListener l) {
    this.tableModelListenerList.remove(l);
  }
}
