/*
 * $Id: SetFontSizeAction.java 72790 2008-02-15 20:05:47Z clinio $
 */
package csbase.client.util.gui.log.actions;

import javax.swing.Action;
import javax.swing.JComponent;

import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.actions.core.AbstractLogAction;
import csbase.client.util.gui.log.enums.FontSize;

/**
 * Define o tamanho da fonte sendo utilizada na rea de texto.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class SetFontSizeAction extends AbstractLogAction {

  /**
   * Tamanho da fonte
   */
  private final FontSize size;

  /**
   * Construtor
   * 
   * @param logPanel o painel
   * @param size tamanho da fonte
   */
  public SetFontSizeAction(final LogPanel logPanel, final FontSize size) {
    super(logPanel);
    this.size = size;
    final String name = size.getLabel();
    putValue(Action.NAME, name);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) throws Exception {
    getLogPanel().getTextArea().setFontSize(size);
  }
}