package csbase.client.util.table;

/**
 * Modelo da Clula: o modelo da clula da {@link Table Tabela}.
 */
public interface CellModel {

  /**
   * Adiciona um observador de modelo de clula.
   * 
   * @param listener O observador (No aceita {@code null}).
   */
  void addCellModelListener(CellModelListener listener);

  /**
   * Obtm o valor atual do modelo de clula.
   * 
   * @return O valor atual.
   */
  Object getValue();

  /**
   * Remove um observador de modelo de clula.
   * 
   * @param listener O observador (No aceita {@code null}).
   */
  void removeCellModelListener(CellModelListener listener);

  /**
   * <p>
   * Atribui um valor da este modelo.
   * </p>
   * 
   * <p>
   * Este mtodo gera o evento
   * {@link CellModelListener#valueWasChanged(CellModel)}.
   * </p>
   * 
   * @param value O novo valor (No aceita {@code null}).
   * 
   * @return {@code true} se houve mudana de estado ou {@code false} se o valor
   *         passado j  o valor atual.
   */
  boolean setValue(Object value);
}
