/*
 * $Id: InputFileParameterView.java 175310 2016-08-03 14:38:03Z fpina $
 */

package csbase.client.algorithms.parameters;

import java.awt.Window;
import java.text.MessageFormat;

import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.desktop.DesktopFrame;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectFileChooser;
import csbase.client.project.ProjectFileChooserOpen;
import csbase.client.project.ProjectTreePath;
import csbase.logic.ClientProjectFile;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.FileURLValue;

/**
 * A Viso para {@link InputFileParameter Parmetro do Tipo Arquivo de Entrada}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class InputFileParameterView extends FileParameterView {

  /**
   * Cria uma viso em modo {@link ParameterView.Mode#CONFIGURATION}.
   *
   * @param window NO EST SENDO UTILIZADO. Existe somente para manter
   *        compatibilidade com o WebSintesi.
   * @param parameter O parmetro (No aceita {@code null}).
   *
   * @deprecated para manter compatibilidade com o WebSintesi
   */
  @Deprecated
  public InputFileParameterView(Window window, InputFileParameter parameter) {
    this(parameter, Mode.CONFIGURATION);
  }

  /**
   * Cria a viso.
   *
   * @param parameter O parmetro (No aceita {@code null}).
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@link ParameterView.Mode#REPORT}.
   */
  public InputFileParameterView(InputFileParameter parameter, Mode mode) {
    super(parameter, mode);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public InputFileParameter getParameter() {
    return (InputFileParameter) super.getParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected final FileURLValue askForFile() {
    try {
      String[] fileTypes = getParameter().getFileTypes();
      String defaultType = null;
      if(fileTypes != null && fileTypes.length > 0) {
        defaultType = fileTypes[0];
      }

      ProjectFileChooser chooser =
        new ProjectFileChooserOpen(getWindow(), DesktopFrame.getInstance()
          .getProject(), false, getFileChooserMode(),
          fileTypes, defaultType, getParameter().usesFilter());
      ProjectTreePath projectTreePath = chooser.getSelectedPath();
      if (projectTreePath == null) {
        return null;
      }
      ClientProjectFile clientProjectFile = projectTreePath.getFile();
      String type = clientProjectFile.getType();
      return new FileURLValue(FileUtils.joinPath('/', projectTreePath.getPath()),
        type);
    }
    catch (ClientException e) {
      String errorMessage =
        "Ocorreu um erro ao abrir o dilogo de seleo de arquivos.";
      if (e.getLocalizedMessage() != null) {
        errorMessage += "\nDetalhes:\n";
        errorMessage += e.getLocalizedMessage();
      }
      StandardDialogs.showErrorDialog(getWindow(),
        "Erro ao abrir o dilogo de seleo de arquivo", errorMessage);
      return null;
    }
  }

  /**
   * Obtm o modo do {@link ProjectFileChooser} que ser utilizado para
   * solicitar os arquivos ao usurio.
   *
   * @return .
   */
  private int getFileChooserMode() {
    int mode;
    FileParameterMode parameterMode = getParameter().getMode();
    if (parameterMode.equals(FileParameterMode.REGULAR_FILE)) {
      mode = ProjectFileChooser.FILE_ONLY;
    }
    else if (parameterMode.equals(FileParameterMode.DIRECTORY)) {
      mode = ProjectFileChooser.DIRECTORY_ONLY;
    }
    else if (parameterMode.equals(FileParameterMode.DIRECTORY_AND_REGULAR_FILE)) {
      mode = ProjectFileChooser.FILE_AND_DIRECTORY;
    }
    else {
      String errorMessage =
        MessageFormat.format("O modo {0} no  vlido.", parameterMode);
      throw new IllegalStateException(errorMessage);
    }
    return mode;
  }
}
