package csbase.client.applications.algorithmsmanager.report.implementations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import csbase.client.applications.Application;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.AlgorithmConfigurator.ConfiguratorType;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.remote.ClientRemoteLocator;

/**
 * Cria e armazena um conjunto de SimpleConfigurator para ser usado como fonte
 * de dadops de um teste. Cria utilizando uma TASK REMOTA.
 *
 * @author Tecgraf/PUC-Rio
 */
public class SimpleConfiguratorSource implements
  Iterable<SimpleAlgorithmConfigurator> {

  /** Lista de ados */
  private List<SimpleAlgorithmConfigurator> list = new ArrayList<>();

  /**
   * Construtor
   * 
   * @param app Aplication para disparar as tasks.
   */
  public SimpleConfiguratorSource(Application app) {
    RemoteTask<List<SimpleAlgorithmConfigurator>> task =
      new RemoteTask<List<SimpleAlgorithmConfigurator>>() {

        @Override
        protected void performTask() throws Exception {
          AlgorithmInfo[] infos = ClientRemoteLocator.algorithmService
            .getAllInfo();
          List<SimpleAlgorithmConfigurator> configurators = new ArrayList<>();

          int i = 0;
          int n = infos.length;
          for (AlgorithmInfo info : infos) {
            setProgressStatus(i * 100 / n);
            if (info != null && info.getLastVersion() != null && info
              .getLastVersion().getType() == ConfiguratorType.SIMPLE) {
              try {
                SimpleAlgorithmConfigurator configurator =
                  (SimpleAlgorithmConfigurator) ClientRemoteLocator.algorithmService
                    .createAlgorithmConfigurator(info.getName(), info
                      .getLastVersion().getId());

                configurators.add(configurator);
              }
              catch (Exception e) {
                //ignora
              }
            }
            i++;
          }
          setResult(configurators);
        }
      };

    task.execute(app.getApplicationFrame(), app.getClassString(getClass(),
      "task.title"), app.getClassString(getClass(), "task.description"), true,
      false);

    if (task.getStatus()) {
      list = task.getResult();
    }
    else {
      list = new ArrayList<>();
    }
  }

  /** {@inheritDoc} */
  @Override
  public Iterator<SimpleAlgorithmConfigurator> iterator() {
    return list.iterator();
  }
}